/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark;

import com.google.common.base.Preconditions;
import org.eclipse.mylyn.wikitext.commonmark.internal.CommonMark;
import org.eclipse.mylyn.wikitext.commonmark.internal.CommonMarkIdGenerationStrategy;
import org.eclipse.mylyn.wikitext.commonmark.internal.InlineContent;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContextBuilder;
import org.eclipse.mylyn.wikitext.commonmark.internal.SourceBlocks;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.markup.IdGenerationStrategy;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;

public class CommonMarkLanguage
extends MarkupLanguage {
    private boolean strictlyConforming = false;

    public CommonMarkLanguage() {
        this.setName("CommonMark");
    }

    public void processContent(MarkupParser parser, String markupContent, boolean asDocument) {
        Preconditions.checkNotNull((Object)parser);
        Preconditions.checkNotNull((Object)markupContent);
        DocumentBuilder builder = (DocumentBuilder)Preconditions.checkNotNull((Object)parser.getBuilder());
        if (asDocument) {
            builder.beginDocument();
        }
        SourceBlocks sourceBlocks = CommonMark.sourceBlocks();
        ProcessingContext context = this.createContext(sourceBlocks, markupContent);
        sourceBlocks.process(context, builder, LineSequence.create(markupContent));
        if (asDocument) {
            builder.endDocument();
        }
    }

    public IdGenerationStrategy getIdGenerationStrategy() {
        return this.isStrictlyConforming() ? null : new CommonMarkIdGenerationStrategy();
    }

    private ProcessingContext createContext(SourceBlocks sourceBlocks, String markupContent) {
        ProcessingContextBuilder contextBuilder = ProcessingContext.builder().idGenerationStrategy(this.getIdGenerationStrategy());
        if (!this.strictlyConforming) {
            contextBuilder.inlineParser(InlineContent.markdown());
        }
        sourceBlocks.createContext(contextBuilder, LineSequence.create(markupContent));
        return contextBuilder.build();
    }

    public void setStrictlyConforming(boolean strictlyConforming) {
        this.strictlyConforming = strictlyConforming;
    }

    public boolean isStrictlyConforming() {
        return this.strictlyConforming;
    }

    public CommonMarkLanguage clone() {
        CommonMarkLanguage language = (CommonMarkLanguage)super.clone();
        language.strictlyConforming = this.strictlyConforming;
        return language;
    }
}

