/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.epub.ncx;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Type implements Enumerator
{
    FRONT(0, "front", "front"),
    NORMAL(1, "normal", "normal"),
    SPECIAL(2, "special", "special");

    public static final int FRONT_VALUE = 0;
    public static final int NORMAL_VALUE = 1;
    public static final int SPECIAL_VALUE = 2;
    private static final Type[] VALUES_ARRAY;
    public static final List<Type> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static Type get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Type result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static Type getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Type result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static Type get(int value) {
        switch (value) {
            case 0: {
                return FRONT;
            }
            case 1: {
                return NORMAL;
            }
            case 2: {
                return SPECIAL;
            }
        }
        return null;
    }

    private Type(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new Type[]{FRONT, NORMAL, SPECIAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

