/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmSpecializedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.util.ITypeReferenceVisitor;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.compiler.BrokenTypeRefDetector;
import org.eclipse.xtext.xbase.compiler.IElementIssueProvider;
import org.eclipse.xtext.xbase.compiler.LoopParams;
import org.eclipse.xtext.xbase.compiler.TypeReferenceSerializer;
import org.eclipse.xtext.xbase.compiler.output.ErrorTreeAppendable;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorSafeExtensions {
    @Inject
    @Extension
    private TypeReferenceSerializer _typeReferenceSerializer;
    @Inject
    private IElementIssueProvider.Factory issueProviderFactory;

    public Iterable<Issue> getErrors(EObject element) {
        Iterable _xblockexpression = null;
        Resource _eResource = element.eResource();
        IElementIssueProvider issueProvider = this.issueProviderFactory.get(_eResource);
        Iterable<Issue> _issues = issueProvider.getIssues(element);
        Functions.Function1<Issue, Boolean> _function = new Functions.Function1<Issue, Boolean>(){

            public Boolean apply(Issue it) {
                Severity _severity = it.getSeverity();
                return Objects.equal((Object)_severity, (Object)Severity.ERROR);
            }
        };
        _xblockexpression = IterableExtensions.filter(_issues, (Functions.Function1)_function);
        return _xblockexpression;
    }

    public boolean hasErrors(EObject element) {
        boolean _xblockexpression = false;
        Resource _eResource = element.eResource();
        IElementIssueProvider issueProvider = this.issueProviderFactory.get(_eResource);
        Iterable<Issue> _issues = issueProvider.getIssues(element);
        Functions.Function1<Issue, Boolean> _function = new Functions.Function1<Issue, Boolean>(){

            public Boolean apply(Issue it) {
                Severity _severity = it.getSeverity();
                return Objects.equal((Object)_severity, (Object)Severity.ERROR);
            }
        };
        _xblockexpression = IterableExtensions.exists(_issues, (Functions.Function1)_function);
        return _xblockexpression;
    }

    public <T extends EObject> void forEachSafely(ITreeAppendable appendable, Iterable<T> elements, Procedures.Procedure1<? super LoopParams> loopInitializer, Procedures.Procedure2<? super T, ? super ITreeAppendable> body) {
        int _size_1;
        boolean _isEmpty = IterableExtensions.isEmpty(elements);
        if (_isEmpty) {
            return;
        }
        LoopParams _loopParams = new LoopParams();
        LoopParams loopParams = (LoopParams)ObjectExtensions.operator_doubleArrow((Object)_loopParams, loopInitializer);
        Functions.Function1 _function = new Functions.Function1<T, Boolean>(){

            public Boolean apply(T it) {
                return ErrorSafeExtensions.this.hasErrors((EObject)it);
            }
        };
        Iterable _filter = IterableExtensions.filter(elements, (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)_filter);
        boolean allElementsBroken = _size == (_size_1 = IterableExtensions.size(elements));
        ITreeAppendable _xifexpression = null;
        if (allElementsBroken) {
            EObject _head = (EObject)IterableExtensions.head(elements);
            _xifexpression = this.openErrorAppendable(appendable, null, _head);
        } else {
            _xifexpression = appendable;
        }
        ITreeAppendable currentAppendable = _xifexpression;
        loopParams.appendPrefix(currentAppendable);
        boolean isFirst = true;
        boolean isFirstBroken = true;
        for (EObject element : elements) {
            boolean _not;
            boolean _hasErrors = this.hasErrors(element);
            boolean bl = _not = !_hasErrors;
            if (_not) {
                ITreeAppendable _closeErrorAppendable;
                currentAppendable = _closeErrorAppendable = this.closeErrorAppendable(appendable, currentAppendable);
                if (!isFirst) {
                    loopParams.appendSeparator(appendable);
                }
                isFirst = false;
                body.apply((Object)element, (Object)appendable);
                continue;
            }
            if (!allElementsBroken) {
                ITreeAppendable _openErrorAppendable;
                currentAppendable = _openErrorAppendable = this.openErrorAppendable(appendable, currentAppendable, element);
            }
            if (!isFirst || !isFirstBroken) {
                loopParams.appendSeparator(currentAppendable);
            }
            isFirstBroken = false;
            try {
                body.apply((Object)element, (Object)currentAppendable);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception exception = (Exception)_t;
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        ITreeAppendable _xifexpression_1 = null;
        _xifexpression_1 = allElementsBroken ? currentAppendable : this.closeErrorAppendable(appendable, currentAppendable);
        currentAppendable = _xifexpression_1;
        loopParams.appendSuffix(currentAppendable);
        this.closeErrorAppendable(appendable, currentAppendable);
    }

    protected ITreeAppendable openErrorAppendable(ITreeAppendable parent, ITreeAppendable child, EObject context) {
        ITreeAppendable _xifexpression = null;
        if (!(child instanceof ErrorTreeAppendable)) {
            ErrorTreeAppendable _errorChild = parent.errorChild(context);
            _xifexpression = _errorChild.append("/* ");
        } else {
            _xifexpression = child;
        }
        return _xifexpression;
    }

    protected ITreeAppendable closeErrorAppendable(ITreeAppendable parent, ITreeAppendable child) {
        boolean _notEquals;
        ITreeAppendable _xblockexpression = null;
        boolean _and = false;
        _and = !(child instanceof ErrorTreeAppendable) ? false : (_notEquals = !Objects.equal((Object)child, (Object)parent));
        if (_and) {
            child.append(" */");
        }
        _xblockexpression = parent;
        return _xblockexpression;
    }

    public void serializeSafely(JvmTypeReference typeRef, ITreeAppendable appendable) {
        this.serializeSafely(typeRef, null, appendable);
    }

    public void serializeSafely(JvmTypeReference typeRef, String surrogateType, ITreeAppendable appendable) {
        boolean _or = false;
        boolean _equals = Objects.equal((Object)typeRef, null);
        if (_equals) {
            _or = true;
        } else {
            boolean _equals_1;
            JvmType _type = typeRef.getType();
            _or = _equals_1 = Objects.equal((Object)_type, null);
        }
        if (_or) {
            boolean _matched = false;
            if (!_matched && typeRef instanceof JvmSpecializedTypeReference) {
                _matched = true;
                JvmTypeReference _equivalent = ((JvmSpecializedTypeReference)typeRef).getEquivalent();
                this.serializeSafely(_equivalent, surrogateType, appendable);
            }
            if (!_matched && typeRef instanceof JvmUnknownTypeReference) {
                _matched = true;
                String _qualifiedName = ((JvmUnknownTypeReference)typeRef).getQualifiedName();
                appendable.append(_qualifiedName);
            }
            if (!_matched) {
                ITreeAppendable errorChild = this.openErrorAppendable(appendable, appendable, (EObject)typeRef);
                errorChild.append("type is 'null'");
                this.closeErrorAppendable(appendable, errorChild);
            }
        } else {
            BrokenTypeRefDetector _brokenTypeRefDetector = new BrokenTypeRefDetector();
            Boolean _accept = (Boolean)typeRef.accept((ITypeReferenceVisitor)_brokenTypeRefDetector);
            if (_accept.booleanValue()) {
                boolean _notEquals;
                EObject _eContainer = typeRef.eContainer();
                ITreeAppendable errorChild = this.openErrorAppendable(appendable, appendable, _eContainer);
                try {
                    EObject _eContainer_1 = typeRef.eContainer();
                    this._typeReferenceSerializer.serialize(typeRef, _eContainer_1, errorChild);
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception exception = (Exception)_t;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                this.closeErrorAppendable(appendable, errorChild);
                boolean bl = _notEquals = !Objects.equal((Object)surrogateType, null);
                if (_notEquals) {
                    appendable.append(surrogateType);
                }
            } else {
                EObject _eContainer_2 = typeRef.eContainer();
                this._typeReferenceSerializer.serialize(typeRef, _eContainer_2, appendable);
            }
        }
    }

    public void serializeSafely(JvmAnnotationReference annotationRef, ITreeAppendable appendable, Procedures.Procedure1<? super ITreeAppendable> onSuccess) {
        boolean _or = false;
        boolean _equals = Objects.equal((Object)annotationRef, null);
        if (_equals) {
            _or = true;
        } else {
            boolean _equals_1;
            JvmAnnotationType _annotation = annotationRef.getAnnotation();
            _or = _equals_1 = Objects.equal((Object)_annotation, null);
        }
        if (_or) {
            ITreeAppendable errorChild = this.openErrorAppendable(appendable, appendable, (EObject)annotationRef);
            errorChild.append("annotation is 'null'");
            this.closeErrorAppendable(appendable, errorChild);
        } else {
            JvmAnnotationType _annotation_1 = annotationRef.getAnnotation();
            boolean _eIsProxy = _annotation_1.eIsProxy();
            if (_eIsProxy) {
                EObject _eContainer = annotationRef.eContainer();
                ITreeAppendable errorChild_1 = this.openErrorAppendable(appendable, appendable, _eContainer);
                appendable.append("@");
                JvmAnnotationType _annotation_2 = annotationRef.getAnnotation();
                appendable.append((JvmType)_annotation_2);
                this.closeErrorAppendable(appendable, errorChild_1);
            } else {
                appendable.append("@");
                JvmAnnotationType _annotation_3 = annotationRef.getAnnotation();
                appendable.append((JvmType)_annotation_3);
                onSuccess.apply((Object)appendable);
            }
        }
    }
}

