/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.outline;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.ide.outline.AbstractMultiModeOutlineTreeProvider;
import org.eclipse.xtend.ide.outline.XtendOutlineJvmTreeProvider;
import org.eclipse.xtend.ide.outline.XtendOutlineSourceTreeProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.IOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.IOutlineTreeStructureProvider;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineMode;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendOutlineTreeProvider
implements IOutlineTreeStructureProvider,
IOutlineTreeProvider,
IOutlineTreeProvider.ModeAware {
    @Inject
    private Provider<XtendOutlineSourceTreeProvider> sourceProvider;
    @Inject
    private Provider<XtendOutlineJvmTreeProvider> jvmProvider;
    @Inject
    private IOutlineTreeProvider.ModeAware modeAware;
    private XtendOutlineSourceTreeProvider sourceTreeProvider;
    private XtendOutlineJvmTreeProvider jvmTreeProvider;
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccess;
    private boolean showJvmModel;

    public IOutlineNode createRoot(IXtextDocument document) {
        this.readCurrentModeFromPrefStore();
        return this.treeProviderInUse().createRoot(document);
    }

    public void createChildren(IOutlineNode parentNode, EObject modelElement) {
        this.readCurrentModeFromPrefStore();
        this.treeProviderInUse().createChildren(parentNode, modelElement);
    }

    private void readCurrentModeFromPrefStore() {
        this.showJvmModel = this.preferenceStoreAccess.getPreferenceStore().getBoolean("ui.outline.switchMode");
    }

    private AbstractMultiModeOutlineTreeProvider treeProviderInUse() {
        if (this.showJvmModel) {
            return this.getJvmTreeProvider();
        }
        return this.getSourceTreeProvider();
    }

    private final XtendOutlineJvmTreeProvider getJvmTreeProvider() {
        if (this.jvmTreeProvider == null) {
            this.jvmTreeProvider = (XtendOutlineJvmTreeProvider)((Object)this.jvmProvider.get());
            this.jvmTreeProvider.setModeAware(this.modeAware);
        }
        return this.jvmTreeProvider;
    }

    private final XtendOutlineSourceTreeProvider getSourceTreeProvider() {
        if (this.sourceTreeProvider == null) {
            this.sourceTreeProvider = (XtendOutlineSourceTreeProvider)((Object)this.sourceProvider.get());
            this.sourceTreeProvider.setModeAware(this.modeAware);
        }
        return this.sourceTreeProvider;
    }

    public List<OutlineMode> getOutlineModes() {
        return this.modeAware.getOutlineModes();
    }

    public OutlineMode getCurrentMode() {
        return this.modeAware.getCurrentMode();
    }

    public OutlineMode getNextMode() {
        return this.modeAware.getNextMode();
    }

    public void setCurrentMode(OutlineMode outlineMode) {
        this.modeAware.setCurrentMode(outlineMode);
    }
}

