/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.internal.MoreTypes;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.xtext.util.Files;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.lib.Functions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnTheFlyJavaCompiler {
    private static PatchedFileSystem fileSystem;
    private List<String> classpath = Lists.newArrayList();
    private DelegateOutStream errorStream = new DelegateOutStream();
    @Inject
    private ClassPathAssembler classPathAssembler = new ClassPathAssembler();

    public void addClassPath(String classpath) {
        this.classpath.add(classpath);
    }

    public void addClassPathOfClass(Class<?> clazz) {
        String resolvedRawPath;
        String classNameAsPath = "/" + clazz.getName().replace('.', '/');
        String resourceName = String.valueOf(classNameAsPath) + ".class";
        URL url = clazz.getResource(resourceName);
        if (url == null) {
            throw new IllegalArgumentException(String.valueOf(resourceName) + " not found");
        }
        String pathToFolderOrJar = null;
        if (url.getProtocol().startsWith("bundleresource")) {
            try {
                url = this.resolveBundleResourceURL(url);
            }
            catch (IOException e) {
                throw new WrappedException((Exception)e);
            }
        }
        if (url.getProtocol().startsWith("jar")) {
            try {
                String path = url.getPath().substring(0, url.getPath().indexOf(33));
                String encodedPath = path.replace(" ", "%20");
                pathToFolderOrJar = new URL(encodedPath).toURI().getRawPath();
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
        try {
            resolvedRawPath = url.toExternalForm().contains(" ") ? URIUtil.toURI((URL)url).getRawPath() : url.toURI().getRawPath();
        }
        catch (URISyntaxException e) {
            throw new WrappedException((Exception)e);
        }
        pathToFolderOrJar = resolvedRawPath.substring(0, resolvedRawPath.indexOf(classNameAsPath));
        this.classpath.add(pathToFolderOrJar);
    }

    public void clearClassPath() {
        if (fileSystem != null && fileSystem.getDelegate() != null) {
            fileSystem.getDelegate().cleanup();
        }
        this.classpath.clear();
        fileSystem = null;
    }

    protected boolean compile(String arguments) {
        return this.getMain().compile(Main.tokenize((String)arguments));
    }

    public Class<?> compileToClass(String classname, String code) {
        return this.compileToClasses(Collections.singletonMap(classname, code)).get(classname);
    }

    public Map<String, Class<?>> compileToClasses(Map<String, String> sources) {
        File tempDir = com.google.common.io.Files.createTempDir();
        try {
            for (Map.Entry<String, String> entry : sources.entrySet()) {
                String classname = entry.getKey();
                String code = entry.getValue();
                String classNameAsPath = classname.replace('.', File.separatorChar);
                File srcFile = new File(tempDir, String.valueOf(classNameAsPath) + ".java");
                this.createFolderStructure(srcFile.getParentFile());
                srcFile.createNewFile();
                Files.writeStringIntoFile((String)srcFile.getCanonicalPath(), (String)code);
            }
            this.errorStream.setDelegate(new ByteArrayOutputStream());
            StringBuilder sb = new StringBuilder(this.getComplianceLevelArg());
            sb.append(" ");
            sb.append(this.getClasspathArgs());
            sb.append(" ");
            sb.append('\"');
            sb.append(tempDir.getCanonicalPath());
            sb.append('\"');
            boolean compile = this.compile(sb.toString());
            if (!compile) {
                throw new IllegalArgumentException("Couldn't compile : " + this.errorStream.toString() + "\n" + sources);
            }
            URL url = tempDir.toURI().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{url}, this.classPathAssembler.getClassLoader());
            HashMap result = Maps.newHashMap();
            for (String name : sources.keySet()) {
                Class<?> clazz = loader.loadClass(name.replace('/', '.'));
                result.put(name, clazz);
            }
            HashMap hashMap = result;
            return hashMap;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.cleanUpTmpFolder(tempDir);
        }
    }

    protected void cleanUpTmpFolder(File tempDir) {
        try {
            tempDir.deleteOnExit();
            Files.cleanFolder((File)tempDir, (FileFilter)new FileFilter(){

                public boolean accept(File pathname) {
                    boolean isClass = pathname.getName().endsWith(".class");
                    if (isClass) {
                        pathname.deleteOnExit();
                    }
                    return !isClass;
                }
            }, (boolean)true, (boolean)true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    protected void createFolderStructure(File parent) {
        if (parent.exists()) {
            return;
        }
        parent.mkdirs();
    }

    protected Pair<String, String> createFullCode(String statementCode, Type returnType, Pair<Type, String> ... params) {
        String className = "_$GeneratedClass";
        StringBuilder sb = new StringBuilder("public class ").append(className).append(" implements ").append("org.eclipse.xtext.xbase.lib.Functions.Function").append(params.length).append("<");
        Pair<Type, String>[] pairArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Pair<Type, String> type = pairArray[n2];
            sb.append(this.toString((Type)type.getFirst())).append(",");
            ++n2;
        }
        sb.append(this.toString(returnType));
        sb.append("> {\n");
        sb.append("public ").append(this.toString(returnType));
        sb.append(" apply(");
        int i = 0;
        while (i < params.length) {
            Pair<Type, String> pair = params[i];
            sb.append(this.toString((Type)pair.getFirst())).append(" ").append((String)pair.getSecond());
            if (i + 1 < params.length) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(") {\n");
        sb.append(statementCode);
        sb.append("\n}}");
        return Tuples.pair((Object)className, (Object)sb.toString());
    }

    public <RT> Functions.Function0<RT> createFunction(String expression, Class<RT> returnType) {
        return (Functions.Function0)this.internalCreateFunction(expression, returnType, new Pair[0]);
    }

    public <RT, T> Functions.Function1<T, RT> createFunction(String body, Class<RT> returnType, Class<T> paramType) {
        return (Functions.Function1)this.internalCreateFunction(body, returnType, Tuples.pair(paramType, (Object)"p"));
    }

    public <RT, T1, T2> Functions.Function2<T1, T2, RT> createFunction(String body, Class<RT> returnType, Class<T1> paramType1, Class<T2> paramType2) {
        return (Functions.Function2)this.internalCreateFunction(body, returnType, Tuples.pair(paramType1, (Object)"p1"), Tuples.pair(paramType2, (Object)"p2"));
    }

    public String getClasspathArgs() {
        StringBuilder sb = new StringBuilder();
        sb.append("-classpath ");
        if (this.classpath.isEmpty()) {
            this.initializeClassPath();
        }
        if (this.classpath.isEmpty()) {
            return "";
        }
        sb.append('\"');
        int i = 0;
        while (i < this.classpath.size()) {
            sb.append(URLDecoder.decode(this.classpath.get(i)));
            if (i + 1 < this.classpath.size()) {
                sb.append(File.pathSeparator);
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString().replace("%20", " ");
    }

    public void initializeClassPath() {
        this.clearClassPath();
        this.classPathAssembler.assembleCompilerClassPath(this);
    }

    protected String getComplianceLevelArg() {
        return "-1.5";
    }

    protected Main getMain() {
        return new PatchedMain(new PrintWriter(new OutputStreamWriter(System.out)), new PrintWriter(new OutputStreamWriter(this.errorStream)), false, null, null);
    }

    protected Object internalCreateFunction(String code, Type returnType, Pair<Type, String> ... params) {
        Pair<String, String> fullCode = this.createFullCode(code, returnType, params);
        Class<?> class1 = this.compileToClass((String)fullCode.getFirst(), (String)fullCode.getSecond());
        try {
            return class1.newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }

    protected URL resolveBundleResourceURL(URL url) throws IOException {
        return FileLocator.resolve((URL)url);
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        this.classPathAssembler.parentClassLoader = parentClassLoader;
    }

    protected String toString(Type returnType) {
        Class<MoreTypes> clazz = MoreTypes.class;
        Method method = null;
        try {
            try {
                method = clazz.getDeclaredMethod("typeToString", Type.class);
            }
            catch (NoSuchMethodException e) {
                method = clazz.getDeclaredMethod("toString", Type.class);
            }
            return (String)method.invoke(null, returnType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ClassPathAssembler {
        @Inject
        private ClassLoader parentClassLoader;

        public void assembleCompilerClassPath(OnTheFlyJavaCompiler compiler) {
            if (this.parentClassLoader instanceof URLClassLoader) {
                URL[] urLs;
                URL[] uRLArray = urLs = ((URLClassLoader)this.parentClassLoader).getURLs();
                int n = urLs.length;
                int n2 = 0;
                while (n2 < n) {
                    URL url = uRLArray[n2];
                    String urlAsString = url.getFile();
                    compiler.addClassPath(urlAsString);
                    ++n2;
                }
            }
        }

        public ClassLoader getClassLoader() {
            return this.parentClassLoader;
        }
    }

    static class DelegateOutStream
    extends OutputStream {
        private OutputStream delegate;

        DelegateOutStream() {
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public void setDelegate(OutputStream delegate) {
            this.delegate = delegate;
        }

        public String toString() {
            return this.delegate.toString();
        }

        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
        }
    }

    public static class EclipseRuntimeDependentJavaCompiler
    extends OnTheFlyJavaCompiler {
        protected URL resolveBundleResourceURL(URL url) throws IOException {
            return FileLocator.resolve((URL)url);
        }
    }

    public static class PatchedFileSystem
    extends FileSystem {
        private FileSystem delegate;

        public PatchedFileSystem(FileSystem delegate) {
            super(new String[0], new String[0], "ISO-8859-1");
            this.delegate = delegate;
        }

        public void cleanup() {
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
            return this.delegate.findType(typeName, packageName);
        }

        public NameEnvironmentAnswer findType(char[][] compoundName) {
            return this.delegate.findType(compoundName);
        }

        public NameEnvironmentAnswer findType(char[][] compoundName, boolean asBinaryOnly) {
            return this.delegate.findType(compoundName, asBinaryOnly);
        }

        public char[][][] findTypeNames(char[][] packageName) {
            return this.delegate.findTypeNames(packageName);
        }

        public FileSystem getDelegate() {
            return this.delegate;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean isPackage(char[][] compoundName, char[] packageName) {
            return this.delegate.isPackage(compoundName, packageName);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    static class PatchedMain
    extends Main {
        public PatchedMain(PrintWriter outWriter, PrintWriter errWriter, boolean systemExitWhenFinished, Map customDefaultOptions, CompilationProgress compilationProgress) {
            super(outWriter, errWriter, systemExitWhenFinished, customDefaultOptions, compilationProgress);
        }

        public FileSystem getLibraryAccess() {
            if (fileSystem == null) {
                fileSystem = new PatchedFileSystem(super.getLibraryAccess());
            }
            return fileSystem;
        }
    }
}

