/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.labeling;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtend.core.jvmmodel.DispatchHelper;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendEnumLiteral;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.labeling.XtendImages;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.ui.labeling.XbaseImageAdornments;
import org.eclipse.xtext.xbase.ui.labeling.XbaseLabelProvider;
import org.eclipse.xtext.xbase.validation.UIStrings;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

public class XtendLabelProvider
extends XbaseLabelProvider {
    @Inject
    private UIStrings uiStrings;
    @Inject
    private XtendImages images;
    @Inject
    @Extension
    private IXtendJvmAssociations _iXtendJvmAssociations;
    @Inject
    private XbaseImageAdornments adornments;
    @Inject
    @Extension
    private DispatchHelper _dispatchHelper;

    @Inject
    public XtendLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected ImageDescriptor _imageDescriptor(XtendFile element) {
        ImageDescriptor _forFile = this.images.forFile();
        return _forFile;
    }

    protected ImageDescriptor _imageDescriptor(XtendClass element) {
        JvmVisibility _visibility = element.getVisibility();
        JvmGenericType _inferredType = this._iXtendJvmAssociations.getInferredType(element);
        int _get = this.adornments.get((JvmIdentifiableElement)_inferredType);
        ImageDescriptor _forClass = this.images.forClass(_visibility, _get);
        return _forClass;
    }

    protected ImageDescriptor _imageDescriptor(XtendInterface element) {
        JvmVisibility _visibility = element.getVisibility();
        JvmGenericType _inferredType = this._iXtendJvmAssociations.getInferredType(element);
        int _get = this.adornments.get((JvmIdentifiableElement)_inferredType);
        ImageDescriptor _forInterface = this.images.forInterface(_visibility, _get);
        return _forInterface;
    }

    protected ImageDescriptor _imageDescriptor(XtendEnum element) {
        JvmVisibility _visibility = element.getVisibility();
        JvmDeclaredType _inferredType = this._iXtendJvmAssociations.getInferredType((XtendTypeDeclaration)element);
        int _get = this.adornments.get((JvmIdentifiableElement)_inferredType);
        ImageDescriptor _forEnum = this.images.forEnum(_visibility, _get);
        return _forEnum;
    }

    protected ImageDescriptor _imageDescriptor(XtendAnnotationType element) {
        JvmVisibility _visibility = element.getVisibility();
        JvmDeclaredType _inferredType = this._iXtendJvmAssociations.getInferredType((XtendTypeDeclaration)element);
        int _get = this.adornments.get((JvmIdentifiableElement)_inferredType);
        ImageDescriptor _forAnnotation = this.images.forAnnotation(_visibility, _get);
        return _forAnnotation;
    }

    protected ImageDescriptor _imageDescriptor(XtendFunction element) {
        JvmVisibility _visibility = element.getVisibility();
        JvmOperation _directlyInferredOperation = this._iXtendJvmAssociations.getDirectlyInferredOperation(element);
        int _get = this.adornments.get((JvmIdentifiableElement)_directlyInferredOperation);
        ImageDescriptor _forOperation = this.images.forOperation(_visibility, _get);
        return _forOperation;
    }

    protected ImageDescriptor _imageDescriptor(JvmOperation operation) {
        ImageDescriptor _xifexpression = null;
        boolean _isDispatcherFunction = this._dispatchHelper.isDispatcherFunction(operation);
        if (_isDispatcherFunction) {
            ImageDescriptor _forDispatcherFunction;
            JvmVisibility _visibility = operation.getVisibility();
            int _get = this.adornments.get((JvmIdentifiableElement)operation);
            _xifexpression = _forDispatcherFunction = this.images.forDispatcherFunction(_visibility, _get);
        } else {
            ImageDescriptor _forOperation;
            JvmVisibility _visibility_1 = operation.getVisibility();
            int _get_1 = this.adornments.get((JvmIdentifiableElement)operation);
            _xifexpression = _forOperation = this.images.forOperation(_visibility_1, _get_1);
        }
        return _xifexpression;
    }

    protected ImageDescriptor _imageDescriptor(XtendConstructor element) {
        JvmVisibility _visibility = element.getVisibility();
        JvmConstructor _inferredConstructor = this._iXtendJvmAssociations.getInferredConstructor(element);
        int _get = this.adornments.get((JvmIdentifiableElement)_inferredConstructor);
        ImageDescriptor _forConstructor = this.images.forConstructor(_visibility, _get);
        return _forConstructor;
    }

    protected ImageDescriptor _imageDescriptor(XtendField element) {
        JvmVisibility _visibility = element.getVisibility();
        JvmField _jvmField = this._iXtendJvmAssociations.getJvmField(element);
        int _get = this.adornments.get((JvmIdentifiableElement)_jvmField);
        ImageDescriptor _forField = this.images.forField(_visibility, _get);
        return _forField;
    }

    protected ImageDescriptor _imageDescriptor(XtendEnumLiteral element) {
        JvmVisibility _visibility = element.getVisibility();
        JvmField _jvmField = this._iXtendJvmAssociations.getJvmField(element);
        int _get = this.adornments.get((JvmIdentifiableElement)_jvmField);
        ImageDescriptor _forField = this.images.forField(_visibility, _get);
        return _forField;
    }

    protected String text(XtendFile element) {
        Resource _eResource = element.eResource();
        URI _uRI = _eResource.getURI();
        URI _trimFileExtension = _uRI.trimFileExtension();
        String _lastSegment = _trimFileExtension.lastSegment();
        return _lastSegment;
    }

    protected String text(XtendClass element) {
        String _name = element.getName();
        String _xifexpression = null;
        EList _typeParameters = element.getTypeParameters();
        boolean _isEmpty = _typeParameters.isEmpty();
        if (_isEmpty) {
            _xifexpression = "";
        } else {
            String _typeParameters_2;
            EList _typeParameters_1 = element.getTypeParameters();
            _xifexpression = _typeParameters_2 = this.uiStrings.typeParameters((Iterable)_typeParameters_1);
        }
        String _plus = String.valueOf(_name) + _xifexpression;
        return _plus;
    }

    protected String text(XtendInterface element) {
        String _name = element.getName();
        String _xifexpression = null;
        EList _typeParameters = element.getTypeParameters();
        boolean _isEmpty = _typeParameters.isEmpty();
        if (_isEmpty) {
            _xifexpression = "";
        } else {
            String _typeParameters_2;
            EList _typeParameters_1 = element.getTypeParameters();
            _xifexpression = _typeParameters_2 = this.uiStrings.typeParameters((Iterable)_typeParameters_1);
        }
        String _plus = String.valueOf(_name) + _xifexpression;
        return _plus;
    }

    protected String text(XtendTypeDeclaration element) {
        String _name = element.getName();
        return _name;
    }

    protected String text(XtendConstructor element) {
        JvmConstructor _inferredConstructor = this._iXtendJvmAssociations.getInferredConstructor(element);
        String _parameters = this.uiStrings.parameters((JvmIdentifiableElement)_inferredConstructor);
        String _plus = "new" + _parameters;
        return _plus;
    }

    protected StyledString text(XtendFunction element) {
        String _name = element.getName();
        JvmOperation _directlyInferredOperation = this._iXtendJvmAssociations.getDirectlyInferredOperation(element);
        StyledString _signature = this.signature(_name, (JvmIdentifiableElement)_directlyInferredOperation);
        return _signature;
    }

    protected StyledString text(XtendField element) {
        StyledString _styledString_3;
        boolean _notEquals;
        StyledString _xblockexpression = null;
        boolean _and = false;
        String _name = element.getName();
        boolean _equals = Objects.equal((Object)_name, null);
        if (!_equals) {
            _and = false;
        } else {
            boolean _isExtension = element.isExtension();
            boolean bl = _and = _equals && _isExtension;
        }
        if (_and) {
            JvmTypeReference _type = element.getType();
            String _referenceToString = this.uiStrings.referenceToString(_type, "extension");
            StyledString _styledString = new StyledString(_referenceToString, StyledString.DECORATIONS_STYLER);
            return _styledString;
        }
        JvmTypeReference fieldType = this.getDisplayedType(element);
        boolean bl = _notEquals = !Objects.equal((Object)fieldType, null);
        if (_notEquals) {
            boolean _notEquals_1;
            String type = this.uiStrings.referenceToString(fieldType, "");
            int _length = type.length();
            boolean bl2 = _notEquals_1 = _length != 0;
            if (_notEquals_1) {
                String _name_1 = element.getName();
                StyledString _styledString_1 = new StyledString(_name_1);
                StyledString _styledString_2 = new StyledString(" : " + type, StyledString.DECORATIONS_STYLER);
                return _styledString_1.append(_styledString_2);
            }
        }
        String _name_2 = element.getName();
        _xblockexpression = _styledString_3 = new StyledString(_name_2);
        return _xblockexpression;
    }

    protected String text(XtendEnumLiteral element) {
        String _name = element.getName();
        return _name;
    }

    protected JvmTypeReference getDisplayedType(XtendField field) {
        EObject next;
        boolean _notEquals;
        JvmTypeReference _xblockexpression = null;
        JvmField jvmField = this._iXtendJvmAssociations.getJvmField(field);
        boolean bl = _notEquals = !Objects.equal((Object)jvmField, null);
        if (_notEquals) {
            return jvmField.getType();
        }
        Set _jvmElements = this._iXtendJvmAssociations.getJvmElements((EObject)field);
        Iterator i = _jvmElements.iterator();
        boolean _hasNext = i.hasNext();
        if (_hasNext && (next = (EObject)i.next()) instanceof JvmOperation) {
            return ((JvmOperation)next).getReturnType();
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    protected ImageDescriptor imageDescriptor(Object constructor) {
        if (constructor instanceof JvmConstructor) {
            return this._imageDescriptor((JvmConstructor)constructor);
        }
        if (constructor instanceof JvmOperation) {
            return this._imageDescriptor((JvmOperation)constructor);
        }
        if (constructor instanceof JvmAnnotationType) {
            return this._imageDescriptor((JvmAnnotationType)constructor);
        }
        if (constructor instanceof JvmEnumerationType) {
            return this._imageDescriptor((JvmEnumerationType)constructor);
        }
        if (constructor instanceof JvmField) {
            return this._imageDescriptor((JvmField)constructor);
        }
        if (constructor instanceof JvmGenericType) {
            return this._imageDescriptor((JvmGenericType)constructor);
        }
        if (constructor instanceof XtendAnnotationType) {
            return this._imageDescriptor((XtendAnnotationType)constructor);
        }
        if (constructor instanceof XtendClass) {
            return this._imageDescriptor((XtendClass)constructor);
        }
        if (constructor instanceof XtendEnum) {
            return this._imageDescriptor((XtendEnum)constructor);
        }
        if (constructor instanceof XtendInterface) {
            return this._imageDescriptor((XtendInterface)constructor);
        }
        if (constructor instanceof JvmTypeParameter) {
            return this._imageDescriptor((JvmTypeParameter)constructor);
        }
        if (constructor instanceof XtendConstructor) {
            return this._imageDescriptor((XtendConstructor)constructor);
        }
        if (constructor instanceof XtendEnumLiteral) {
            return this._imageDescriptor((XtendEnumLiteral)constructor);
        }
        if (constructor instanceof XtendField) {
            return this._imageDescriptor((XtendField)constructor);
        }
        if (constructor instanceof XtendFunction) {
            return this._imageDescriptor((XtendFunction)constructor);
        }
        if (constructor instanceof JvmFormalParameter) {
            return this._imageDescriptor((JvmFormalParameter)constructor);
        }
        if (constructor instanceof XVariableDeclaration) {
            return this._imageDescriptor((XVariableDeclaration)constructor);
        }
        if (constructor instanceof XtendFile) {
            return this._imageDescriptor((XtendFile)constructor);
        }
        if (constructor instanceof XImportDeclaration) {
            return this._imageDescriptor((XImportDeclaration)constructor);
        }
        if (constructor instanceof XImportSection) {
            return this._imageDescriptor((XImportSection)constructor);
        }
        if (constructor != null) {
            return this._imageDescriptor(constructor);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(constructor).toString());
    }
}

