/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.documentation.impl;

import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.documentation.IEObjectDocumentationProviderExtension;
import org.eclipse.xtext.documentation.impl.AbstractMultiLineCommentProvider;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class MultiLineCommentDocumentationProvider
extends AbstractMultiLineCommentProvider
implements IEObjectDocumentationProvider,
IEObjectDocumentationProviderExtension {
    protected String findComment(EObject o) {
        String returnValue = null;
        List<INode> documentationNodes = this.getDocumentationNodes(o);
        if (!documentationNodes.isEmpty()) {
            return documentationNodes.get(0).getText();
        }
        return returnValue;
    }

    @Override
    @NonNull
    public List<INode> getDocumentationNodes(@NonNull EObject object) {
        ICompositeNode node = NodeModelUtils.getNode(object);
        List<INode> result = Collections.emptyList();
        if (node != null) {
            for (ILeafNode leafNode : node.getLeafNodes()) {
                String comment;
                if (!leafNode.isHidden()) break;
                if (!(leafNode.getGrammarElement() instanceof TerminalRule) || !this.ruleName.equalsIgnoreCase(((TerminalRule)leafNode.getGrammarElement()).getName()) || !(comment = leafNode.getText()).matches("(?s)" + this.startTag + ".*")) continue;
                result = Collections.singletonList(leafNode);
            }
        }
        return result;
    }

    @Override
    public String getDocumentation(EObject o) {
        String returnValue = this.findComment(o);
        return this.getTextFromMultilineComment(returnValue);
    }
}

