/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;

@NonNullByDefault
public class ArrayTypes {
    @Nullable
    public ArrayTypeReference tryConvertToArray(ParameterizedTypeReference typeReference) {
        if (typeReference.isSubtypeOf(Iterable.class)) {
            DeclaratorTypeArgumentCollector collector = new DeclaratorTypeArgumentCollector();
            Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> parameterMapping = collector.getTypeParameterMapping(typeReference);
            JvmType iterableType = typeReference.getOwner().getServices().getTypeReferences().findDeclaredType(Iterable.class, (Notifier)typeReference.getOwner().getContextResourceSet());
            if (iterableType instanceof JvmTypeParameterDeclarator) {
                ParameterizedTypeReference unboundTypeParameter;
                JvmTypeParameter typeParameter = (JvmTypeParameter)((JvmTypeParameterDeclarator)iterableType).getTypeParameters().get(0);
                UnboundTypeParameterPreservingSubstitutor substitutor = new UnboundTypeParameterPreservingSubstitutor(parameterMapping, typeReference.getOwner());
                LightweightTypeReference componentType = substitutor.substitute(unboundTypeParameter = new ParameterizedTypeReference(typeReference.getOwner(), (JvmType)typeParameter)).getUpperBoundSubstitute();
                if (componentType.isAny()) {
                    return null;
                }
                ArrayTypeReference array = new ArrayTypeReference(typeReference.getOwner(), componentType);
                return array;
            }
        }
        return null;
    }

    public ParameterizedTypeReference convertToList(ArrayTypeReference type) {
        LightweightTypeReference componentType = type.getComponentType();
        LightweightTypeReference wrapper = componentType.getWrapperTypeIfPrimitive();
        JvmType listType = type.getServices().getTypeReferences().findDeclaredType(List.class, (Notifier)type.getOwner().getContextResourceSet());
        ParameterizedTypeReference result = new ParameterizedTypeReference(type.getOwner(), listType);
        result.addTypeArgument(wrapper);
        return result;
    }
}

