/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.typesystem.computation.AbstractClosureTypeHelper;
import org.eclipse.xtext.xbase.typesystem.computation.ClosureWithExpectationHelper;
import org.eclipse.xtext.xbase.typesystem.computation.ClosureWithoutExpectationHelper;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.computation.UnknownClosureTypeHelper;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

@NonNullByDefault
public class ClosureTypeComputer {
    private final XClosure closure;
    private final ITypeComputationState state;
    private final CommonTypeComputationServices services;
    private final FunctionTypes functionTypes;
    private final ITypeExpectation expectation;
    private AbstractClosureTypeHelper strategy;

    public ClosureTypeComputer(XClosure closure, ITypeExpectation expectation, ITypeComputationState state) {
        this.closure = closure;
        this.expectation = expectation;
        this.state = state;
        this.services = state.getReferenceOwner().getServices();
        this.functionTypes = this.services.getFunctionTypes();
    }

    public void computeTypes() {
        this.selectStrategy();
        this.strategy.computeTypes();
    }

    public void selectStrategy() {
        LightweightTypeReference expectedType = this.expectation.getExpectedType();
        if (expectedType == null) {
            this.strategy = this.getClosureWithoutExpectationHelper();
        } else {
            JvmOperation operation = this.functionTypes.findImplementingOperation(expectedType);
            JvmType type = expectedType.getType();
            int closureParameterSize = this.closure.getFormalParameters().size();
            this.strategy = operation == null || operation.getParameters().size() != closureParameterSize || type == null ? this.getClosureWithoutExpectationHelper() : this.createClosureWithExpectationHelper(operation);
        }
    }

    protected AbstractClosureTypeHelper getClosureWithoutExpectationHelper() {
        if (this.functionTypes.isFunctionAndProcedureAvailable(this.expectation.getReferenceOwner())) {
            return this.createClosureWithoutExpectationHelper();
        }
        return this.createUnknownClosureTypeHelper();
    }

    protected ClosureWithExpectationHelper createClosureWithExpectationHelper(JvmOperation operation) {
        return new ClosureWithExpectationHelper(this.closure, operation, this.expectation, this.state);
    }

    protected UnknownClosureTypeHelper createUnknownClosureTypeHelper() {
        return new UnknownClosureTypeHelper(this.closure, this.expectation, this.state);
    }

    protected ClosureWithoutExpectationHelper createClosureWithoutExpectationHelper() {
        return new ClosureWithoutExpectationHelper(this.closure, this.expectation, this.state);
    }

    protected XClosure getClosure() {
        return this.closure;
    }

    protected ITypeExpectation getExpectation() {
        return this.expectation;
    }

    protected ITypeComputationState getState() {
        return this.state;
    }

    @Nullable
    public FunctionTypeReference getExpectedClosureType() {
        if (this.strategy == null) {
            this.selectStrategy();
        }
        return this.strategy.getExpectedClosureType();
    }

    @Nullable
    public JvmOperation getOperation() {
        if (this.strategy == null) {
            this.selectStrategy();
        }
        return this.strategy.getOperation();
    }
}

