/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedScope;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.batch.ExpressionBucket;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.InstanceExtensionDescription;
import org.eclipse.xtext.xbase.scoping.batch.InstanceExtensionDescriptionWithImplicitFirstArgument;
import org.eclipse.xtext.xbase.scoping.batch.InstanceFeatureDescriptionWithImplicitReceiver;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicExtensionsScope
extends AbstractSessionBasedScope {
    private final OperatorMapping operatorMapping;
    private final XExpression firstArgument;
    private final LightweightTypeReference argumentType;
    private final boolean implicit;
    private Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> argumentTypeParameterMapping;

    public DynamicExtensionsScope(IScope parent, IFeatureScopeSession session, XExpression firstArgument, LightweightTypeReference argumentType, boolean implicit, XAbstractFeatureCall context, OperatorMapping operatorMapping) {
        super(parent, session, context);
        this.firstArgument = firstArgument;
        this.argumentType = argumentType;
        this.implicit = implicit;
        this.operatorMapping = operatorMapping;
    }

    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getArgumentTypeParameterMapping() {
        if (this.argumentTypeParameterMapping == null) {
            this.argumentTypeParameterMapping = Collections.emptyMap();
            if (this.argumentType != null) {
                this.argumentTypeParameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(this.argumentType);
            }
        }
        return this.argumentTypeParameterMapping;
    }

    protected Iterable<IEObjectDescription> getAllLocalElements() {
        List<ExpressionBucket> buckets = this.getBuckets();
        if (buckets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (ExpressionBucket bucket : buckets) {
            Map<XExpression, LightweightTypeReference> extensionProviders = bucket.getExtensionProviders();
            for (Map.Entry<XExpression, LightweightTypeReference> extensionProvider : extensionProviders.entrySet()) {
                LinkedHashSet allFeatures = Sets.newLinkedHashSet();
                LightweightTypeReference extensionType = extensionProvider.getValue();
                List<JvmType> types = extensionType.getRawTypes();
                for (JvmType type : types) {
                    if (!(type instanceof JvmDeclaredType)) continue;
                    Iterable features = ((JvmDeclaredType)type).getAllFeatures();
                    Iterables.addAll((Collection)allFeatures, (Iterable)features);
                }
                if (allFeatures.isEmpty()) continue;
                Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(extensionType);
                for (JvmFeature feature : allFeatures) {
                    this.addDescriptions(feature, extensionProvider.getKey(), extensionType, receiverTypeParameterMapping, bucket, result);
                }
            }
        }
        return result;
    }

    protected void addDescriptions(JvmFeature feature, XExpression receiver, LightweightTypeReference receiverType, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping, ExpressionBucket bucket, List<IEObjectDescription> result) {
        QualifiedName operator;
        QualifiedName featureName = QualifiedName.create((String)feature.getSimpleName());
        if (this.firstArgument != null) {
            result.add(this.createDescription(featureName, feature, receiver, receiverType, receiverTypeParameterMapping, bucket));
        }
        if (this.implicit) {
            result.add(this.createReceiverDescription(featureName, feature, receiver, receiverType, receiverTypeParameterMapping, bucket));
        }
        if ((operator = this.operatorMapping.getOperator(featureName)) != null) {
            if (this.firstArgument != null) {
                result.add(this.createDescription(operator, feature, receiver, receiverType, receiverTypeParameterMapping, bucket));
            }
            if (this.implicit) {
                result.add(this.createReceiverDescription(operator, feature, receiver, receiverType, receiverTypeParameterMapping, bucket));
            }
        }
    }

    protected List<ExpressionBucket> getBuckets() {
        return this.getSession().getExtensionProviders();
    }

    @Override
    protected Collection<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        List<ExpressionBucket> buckets = this.getBuckets();
        if (buckets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (ExpressionBucket bucket : buckets) {
            Map<XExpression, LightweightTypeReference> extensionProviders = bucket.getExtensionProviders();
            for (Map.Entry<XExpression, LightweightTypeReference> extensionProvider : extensionProviders.entrySet()) {
                LightweightTypeReference extensionType = extensionProvider.getValue();
                if (extensionType == null) {
                    throw new IllegalStateException("extensionType is null");
                }
                final List<JvmType> types = extensionType.getRawTypes();
                final LinkedHashSet allFeatures = Sets.newLinkedHashSet();
                this.processFeatureNames(name, new AbstractSessionBasedScope.NameAcceptor(){

                    public void accept(String simpleName, int order) {
                        for (JvmType type : types) {
                            if (!(type instanceof JvmDeclaredType)) continue;
                            Iterable features = ((JvmDeclaredType)type).findAllFeaturesByName(simpleName);
                            Iterable filtered = order == 1 ? features : Iterables.filter((Iterable)features, JvmOperation.class);
                            Iterables.addAll((Collection)allFeatures, (Iterable)filtered);
                        }
                    }
                });
                if (allFeatures.isEmpty()) continue;
                Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(extensionType);
                for (JvmFeature feature : allFeatures) {
                    BucketedEObjectDescription description;
                    if (feature.isStatic()) continue;
                    if (this.firstArgument != null && (description = this.createDescription(name, feature, extensionProvider.getKey(), extensionType, receiverTypeParameterMapping, bucket)) != null) {
                        result.add(description);
                    }
                    if (!this.implicit) continue;
                    result.add(this.createReceiverDescription(name, feature, extensionProvider.getKey(), extensionType, receiverTypeParameterMapping, bucket));
                }
            }
        }
        return result;
    }

    @Override
    protected void processFeatureNames(QualifiedName name, AbstractSessionBasedScope.NameAcceptor acceptor) {
        QualifiedName methodName = this.operatorMapping.getMethodName(name);
        if (methodName != null) {
            acceptor.accept(methodName.toString(), 2);
        } else {
            super.processFeatureNames(name, acceptor);
            this.processAsPropertyNames(name, acceptor);
        }
    }

    protected BucketedEObjectDescription createDescription(QualifiedName name, JvmFeature feature, XExpression receiver, LightweightTypeReference receiverType, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping, ExpressionBucket bucket) {
        if (!(feature instanceof JvmOperation)) {
            return null;
        }
        EList parameters = ((JvmExecutable)feature).getParameters();
        if (parameters.isEmpty()) {
            return null;
        }
        if (this.implicit) {
            return new InstanceExtensionDescriptionWithImplicitFirstArgument(name, feature, receiver, receiverType, receiverTypeParameterMapping, EnumSet.of(ConformanceHint.SUCCESS, ConformanceHint.CHECKED), this.firstArgument, this.argumentType, this.getArgumentTypeParameterMapping(), bucket.getId(), this.getSession().isVisible((JvmMember)feature));
        }
        return new InstanceExtensionDescription(name, feature, receiver, receiverType, receiverTypeParameterMapping, EnumSet.of(ConformanceHint.SUCCESS, ConformanceHint.CHECKED), this.firstArgument, this.argumentType, this.getArgumentTypeParameterMapping(), EnumSet.of(ConformanceHint.UNCHECKED), bucket.getId(), this.getSession().isVisible((JvmMember)feature));
    }

    protected BucketedEObjectDescription createReceiverDescription(QualifiedName name, JvmFeature feature, XExpression receiver, LightweightTypeReference receiverType, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping, ExpressionBucket bucket) {
        return new InstanceFeatureDescriptionWithImplicitReceiver(name, feature, receiver, receiverType, receiverTypeParameterMapping, EnumSet.of(ConformanceHint.SUCCESS, ConformanceHint.CHECKED), bucket.getId(), this.getSession().isVisible((JvmMember)feature));
    }
}

