/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parsetree.reconstr;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting.IFormatter;
import org.eclipse.xtext.formatting.IFormatterExtension;
import org.eclipse.xtext.parsetree.reconstr.IParseTreeConstructor;
import org.eclipse.xtext.parsetree.reconstr.ITokenStream;
import org.eclipse.xtext.parsetree.reconstr.SerializerOptions;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenStringBuffer;
import org.eclipse.xtext.parsetree.reconstr.impl.WriterTokenStream;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.validation.IConcreteSyntaxValidator;

public class Serializer
implements ISerializer {
    private IParseTreeConstructor parseTreeReconstructor;
    private IFormatter formatter;
    private IConcreteSyntaxValidator validator;

    @Inject
    public Serializer(IParseTreeConstructor ptc, IFormatter fmt, IConcreteSyntaxValidator val) {
        this.parseTreeReconstructor = ptc;
        this.formatter = fmt;
        this.validator = val;
    }

    public IParseTreeConstructor.TreeConstructionReport serialize(EObject obj, ITokenStream tokenStream, SaveOptions options) throws IOException {
        if (options.isValidating()) {
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
            this.validator.validateRecursive(obj, new IConcreteSyntaxValidator.DiagnosticListAcceptor(diagnostics), new HashMap<Object, Object>());
            if (!diagnostics.isEmpty()) {
                throw new IConcreteSyntaxValidator.InvalidConcreteSyntaxException("These errors need to be fixed before the model can be serialized.", diagnostics);
            }
        }
        ITokenStream formatterTokenStream = this.formatter instanceof IFormatterExtension ? ((IFormatterExtension)((Object)this.formatter)).createFormatterStream(obj, null, tokenStream, !options.isFormatting()) : this.formatter.createFormatterStream(null, tokenStream, !options.isFormatting());
        IParseTreeConstructor.TreeConstructionReport report = this.parseTreeReconstructor.serializeSubtree(obj, formatterTokenStream);
        formatterTokenStream.flush();
        return report;
    }

    public void serialize(EObject obj, Writer writer, SaveOptions options) throws IOException {
        this.serialize(obj, (ITokenStream)new WriterTokenStream(writer), options);
    }

    public String serialize(EObject obj) {
        return this.serialize(obj, SaveOptions.defaultOptions());
    }

    public String serialize(EObject obj, SaveOptions options) {
        TokenStringBuffer tokenStringBuffer = new TokenStringBuffer();
        try {
            this.serialize(obj, (ITokenStream)tokenStringBuffer, options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tokenStringBuffer.toString();
    }

    @Deprecated
    public IParseTreeConstructor.TreeConstructionReport serialize(EObject obj, ITokenStream tokenStream, SerializerOptions options) throws IOException {
        return this.serialize(obj, tokenStream, options.toSaveOptions());
    }

    @Deprecated
    public IParseTreeConstructor.TreeConstructionReport serialize(EObject obj, Writer writer, SerializerOptions options) throws IOException {
        return this.serialize(obj, (ITokenStream)new WriterTokenStream(writer), options.toSaveOptions());
    }

    @Deprecated
    public String serialize(EObject obj, SerializerOptions options) {
        return this.serialize(obj, options.toSaveOptions());
    }

    public ReplaceRegion serializeReplacement(EObject obj, SaveOptions options) {
        TokenStringBuffer tokenStringBuffer = new TokenStringBuffer();
        try {
            IParseTreeConstructor.TreeConstructionReport report = this.serialize(obj, (ITokenStream)tokenStringBuffer, options);
            return new ReplaceRegion(report.getPreviousLocation(), tokenStringBuffer.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected IParseTreeConstructor getParseTreeReconstructor() {
        return this.parseTreeReconstructor;
    }

    protected IFormatter getFormatter() {
        return this.formatter;
    }

    protected IConcreteSyntaxValidator getValidator() {
        return this.validator;
    }
}

