/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeConformanceComputationArgument;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.MergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class BoundTypeArgumentMerger {
    @Inject
    private TypeConformanceComputer conformanceComputer;

    @Nullable
    public MergedBoundTypeArgument merge(Collection<BoundTypeArgument> allArguments) {
        if (allArguments.isEmpty()) {
            return null;
        }
        if (allArguments.size() == 1) {
            BoundTypeArgument argument = (BoundTypeArgument)Iterables.getOnlyElement(allArguments);
            return new MergedBoundTypeArgument(argument.getTypeReference(), argument.getDeclaredVariance().mergeDeclaredWithActual(argument.getActualVariance()));
        }
        ArrayList invariantTypes = Lists.newArrayListWithCapacity((int)3);
        ArrayList invariantVariances = Lists.newArrayListWithCapacity((int)3);
        ArrayList outTypes = Lists.newArrayListWithCapacity((int)3);
        ArrayList constraintOutTypes = Lists.newArrayListWithCapacity((int)3);
        ArrayList outVariances = Lists.newArrayListWithCapacity((int)3);
        ArrayList inTypes = Lists.newArrayListWithCapacity((int)3);
        ArrayList inVariances = Lists.newArrayListWithCapacity((int)3);
        HashSet seenOrigin = Sets.newHashSet();
        block5: for (BoundTypeArgument boundTypeArgument : allArguments) {
            Object origin = boundTypeArgument.getOrigin();
            switch (boundTypeArgument.getDeclaredVariance()) {
                case INVARIANT: {
                    invariantTypes.add(boundTypeArgument.getTypeReference());
                    if (!seenOrigin.add(origin) && origin != null && !boundTypeArgument.isValidVariancePair()) continue block5;
                    invariantVariances.add(boundTypeArgument.getActualVariance());
                    break;
                }
                case OUT: {
                    if (boundTypeArgument.getSource() == BoundTypeArgumentSource.CONSTRAINT) {
                        constraintOutTypes.add(boundTypeArgument.getTypeReference());
                    } else {
                        outTypes.add(boundTypeArgument.getTypeReference());
                    }
                    if (!seenOrigin.add(origin) && origin != null && !boundTypeArgument.isValidVariancePair()) continue block5;
                    outVariances.add(boundTypeArgument.getActualVariance());
                    break;
                }
                case IN: {
                    inTypes.add(boundTypeArgument.getTypeReference());
                    if (!seenOrigin.add(origin) && origin != null && !boundTypeArgument.isValidVariancePair()) continue block5;
                    inVariances.add(boundTypeArgument.getActualVariance());
                }
            }
        }
        JvmTypeReference type = null;
        VarianceInfo variance = null;
        if (outTypes.isEmpty()) {
            outTypes.addAll(constraintOutTypes);
        }
        if (!invariantTypes.isEmpty()) {
            type = (JvmTypeReference)invariantTypes.get(0);
            variance = VarianceInfo.INVARIANT.mergeDeclaredWithActuals(invariantVariances);
            if (!outVariances.isEmpty()) {
                VarianceInfo outVariance = VarianceInfo.OUT.mergeDeclaredWithActuals(outVariances);
                variance = VarianceInfo.OUT.mergeInvariance(variance, outVariance);
            } else if (!inVariances.isEmpty()) {
                VarianceInfo inVariance = VarianceInfo.IN.mergeDeclaredWithActuals(inVariances);
                variance = VarianceInfo.IN.mergeInvariance(variance, inVariance);
            }
        } else if (!outTypes.isEmpty()) {
            type = this.conformanceComputer.getCommonSuperType((List)outTypes);
            variance = VarianceInfo.OUT.mergeDeclaredWithActuals(outVariances);
            if (!inVariances.isEmpty()) {
                JvmTypeReference inType = this.getMostSpecialType(inTypes);
                boolean conformant = this.conformanceComputer.isConformant(type, inType, new TypeConformanceComputationArgument(false, true, false)).isConformant();
                VarianceInfo inVariance = VarianceInfo.IN.mergeDeclaredWithActuals(inVariances);
                variance = VarianceInfo.IN.mergeWithOut(variance, inVariance, conformant);
            }
        } else if (!inTypes.isEmpty()) {
            type = this.getMostSpecialType(inTypes);
            variance = VarianceInfo.IN.mergeDeclaredWithActuals(inVariances);
        }
        return new MergedBoundTypeArgument(type, variance);
    }

    protected JvmTypeReference getMostSpecialType(List<JvmTypeReference> candidates) {
        JvmTypeReference type = candidates.get(0);
        int i = 1;
        while (i < candidates.size()) {
            JvmTypeReference candidate = candidates.get(i);
            if (this.conformanceComputer.isConformant(type, candidate)) {
                type = candidate;
            }
            ++i;
        }
        return type;
    }
}

