/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.refactoring;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtend.core.formatting.IImportCollection;
import org.eclipse.xtend.core.formatting.OrganizeImports;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendImport;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.IRefactoringDocument;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.JvmModelReferenceUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendReferenceUpdater
extends JvmModelReferenceUpdater {
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private OrganizeImports organizeImports;
    @Inject
    private IWhitespaceInformationProvider whitespaceInformationProvider;

    protected void processReferringResource(Resource referringResource, Iterable<IReferenceDescription> referenceDescriptions, ElementRenameArguments elementRenameArguments, IRefactoringUpdateAcceptor updateAcceptor) {
        Iterable nonImportReferences = Iterables.filter(referenceDescriptions, (Predicate)new Predicate<IReferenceDescription>(){

            public boolean apply(IReferenceDescription input) {
                return !XtendReferenceUpdater.this.isImportTypeReference(input);
            }
        });
        ImportAwareUpdateAcceptor importAwareUpdateAcceptor = this.createUpdateAcceptor(updateAcceptor);
        super.processReferringResource(referringResource, nonImportReferences, elementRenameArguments, (IRefactoringUpdateAcceptor)importAwareUpdateAcceptor);
        RefactoringImports importCollection = this.createRefactoringImports(referringResource);
        importCollection.addImportedNames(importAwareUpdateAcceptor.getAdditionalImportedNames());
        TextRegion importRegion = this.organizeImports.computeRegion((XtextResource)referringResource);
        String lineSeparator = this.whitespaceInformationProvider.getLineSeparatorInformation(referringResource.getURI()).getLineSeparator();
        String importSection = this.organizeImports.serializeImports((IImportCollection)importCollection, lineSeparator);
        ReplaceEdit importChange = new ReplaceEdit(importRegion.getOffset(), importRegion.getLength(), importSection);
        updateAcceptor.accept(referringResource.getURI(), (TextEdit)importChange);
    }

    protected RefactoringImports createRefactoringImports(Resource referringResource) {
        return new RefactoringImports(referringResource);
    }

    protected ImportAwareUpdateAcceptor createUpdateAcceptor(IRefactoringUpdateAcceptor updateAcceptor) {
        return new ImportAwareUpdateAcceptor(updateAcceptor);
    }

    protected boolean isImportTypeReference(IReferenceDescription input) {
        return input.getEReference() == XtendPackage.Literals.XTEND_IMPORT__IMPORTED_TYPE;
    }

    protected void createTextChange(ITextRegion referenceTextRegion, String newReferenceText, EObject referringElement, EObject newTargetElement, EReference reference, URI referringResourceURI, IRefactoringUpdateAcceptor updateAcceptor) {
        if (newTargetElement instanceof JvmType && updateAcceptor instanceof ImportAwareUpdateAcceptor && newReferenceText.contains(".")) {
            IEObjectDescription singleElement;
            String simpleName = ((JvmType)newTargetElement).getSimpleName();
            IScope scope = this.scopeProvider.getScope(referringElement, reference);
            if (scope != null && (singleElement = scope.getSingleElement(QualifiedName.create((String)simpleName))) == null) {
                newReferenceText = simpleName;
                ((ImportAwareUpdateAcceptor)updateAcceptor).acceptImport(((JvmType)newTargetElement).getQualifiedName());
            }
        }
        super.createTextChange(referenceTextRegion, newReferenceText, referringElement, newTargetElement, reference, referringResourceURI, updateAcceptor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImportAwareUpdateAcceptor
    implements IRefactoringUpdateAcceptor {
        private IRefactoringUpdateAcceptor delegate;
        private List<String> additionalImportedNames;

        public ImportAwareUpdateAcceptor(IRefactoringUpdateAcceptor delegate) {
            this.delegate = delegate;
        }

        public void accept(URI resourceURI, TextEdit textEdit) {
            this.delegate.accept(resourceURI, textEdit);
        }

        public void accept(URI resourceURI, Change change) {
            this.delegate.accept(resourceURI, change);
        }

        public StatusWrapper getRefactoringStatus() {
            return this.delegate.getRefactoringStatus();
        }

        public IRefactoringDocument getDocument(URI resourceURI) {
            return this.delegate.getDocument(resourceURI);
        }

        public Change createCompositeChange(String name, IProgressMonitor monitor) {
            return this.delegate.createCompositeChange(name, monitor);
        }

        public void acceptImport(String qualifiedName) {
            if (this.additionalImportedNames == null) {
                this.additionalImportedNames = Lists.newArrayList();
            }
            this.additionalImportedNames.add(qualifiedName);
        }

        public List<String> getAdditionalImportedNames() {
            return this.additionalImportedNames;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefactoringImports
    implements IImportCollection {
        private Set<String> plainImports = Sets.newLinkedHashSet();
        private Set<String> staticImports = Sets.newLinkedHashSet();
        private Set<String> staticExtensionImports = Sets.newLinkedHashSet();

        public RefactoringImports(Resource xtendResource) {
            XtendFile xtendFile = (XtendFile)xtendResource.getContents().get(0);
            for (XtendImport xtendImport : xtendFile.getImports()) {
                if (xtendImport.getImportedNamespace() == null) {
                    JvmType importedType = xtendImport.getImportedType();
                    if (importedType == null || importedType.eIsProxy()) continue;
                    String importedTypeName = xtendImport.getImportedTypeName();
                    if (!importedType.getIdentifier().equals(importedTypeName)) continue;
                    this.getSet(xtendImport).add(importedTypeName);
                    continue;
                }
                this.getSet(xtendImport).add(xtendImport.getImportedNamespace());
            }
        }

        public List<String> getListofImportedTypeNames() {
            return Lists.newArrayList(this.plainImports);
        }

        public List<String> getListofStaticImports() {
            return Lists.newArrayList(this.staticImports);
        }

        public List<String> getListofStaticExtensionImports() {
            return Lists.newArrayList(this.staticExtensionImports);
        }

        public void addImportedNames(List<String> importedNames) {
            if (importedNames != null) {
                this.plainImports.addAll(importedNames);
            }
        }

        public void remove(XtendImport xtendImport) {
            this.getSet(xtendImport).remove(this.getImportedName(xtendImport));
        }

        protected Set<String> getSet(XtendImport xtendImport) {
            if (xtendImport.isStatic()) {
                if (xtendImport.isExtension()) {
                    return this.staticExtensionImports;
                }
                return this.staticImports;
            }
            return this.plainImports;
        }

        protected String getImportedName(XtendImport xtendImport) {
            if (xtendImport.getImportedNamespace() == null) {
                return xtendImport.getImportedTypeName();
            }
            return xtendImport.getImportedNamespace();
        }
    }
}

