/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.buildpath;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.xtend2.ui.buildpath.Messages;
import org.eclipse.xtext.xtend2.ui.internal.Xtend2Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class XtendContainerInitializer
extends ClasspathContainerInitializer {
    private static final String XTEXT_XTEND2_LIB_BUNDLE_ID = "org.eclipse.xtend2.lib";
    private static final String XTEXT_XBASE_LIB_BUNDLE_ID = "org.eclipse.xtext.xbase.lib";
    public static final Path XTEND_LIBRARY_PATH = new Path("org.eclipse.xtend.XTEND_CONTAINER");
    public static final String[] BUNDLE_IDS_TO_INCLUDE = new String[]{"com.google.guava", "com.google.inject", "org.eclipse.xtext.xbase.lib", "org.eclipse.xtend2.lib"};
    private static final Logger LOG = Logger.getLogger(XtendContainerInitializer.class);

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (this.isXtendPath(containerPath)) {
            IClasspathContainer container = this.createContainer(containerPath);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(final IPath containerPath, final IJavaProject project, final IClasspathContainer containerSuggestion) throws CoreException {
        super.requestClasspathContainerUpdate(containerPath, project, containerSuggestion);
        new Job("Classpath container update"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{containerSuggestion}, null);
                }
                catch (CoreException ex) {
                    return new Status(4, Xtend2Activator.getInstance().getBundle().getSymbolicName(), 0, "Classpath container update failed", (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private IClasspathContainer createContainer(IPath containerPath) {
        return new XtendClasspathContainer(containerPath);
    }

    private boolean isXtendPath(IPath containerPath) {
        return XTEND_LIBRARY_PATH.equals((Object)containerPath);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class XtendClasspathContainer
    implements IClasspathContainer {
        private static final String SOURCE_SUFIX = ".source";
        private final IPath containerPath;

        private XtendClasspathContainer(IPath containerPath) {
            this.containerPath = containerPath;
        }

        public IClasspathEntry[] getClasspathEntries() {
            ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
            String[] stringArray = BUNDLE_IDS_TO_INCLUDE;
            int n = BUNDLE_IDS_TO_INCLUDE.length;
            int n2 = 0;
            while (n2 < n) {
                String bundleId = stringArray[n2];
                this.addEntry(cpEntries, bundleId);
                ++n2;
            }
            return cpEntries.toArray(new IClasspathEntry[0]);
        }

        private void addEntry(List<IClasspathEntry> cpEntries, String bundleId) {
            IPath bundlePath = this.findBundle(bundleId);
            if (bundlePath != null) {
                IPath sourceBundlePath = this.findBundle(bundleId.concat(SOURCE_SUFIX));
                IClasspathAttribute[] extraAttributes = null;
                if (XtendContainerInitializer.XTEXT_XBASE_LIB_BUNDLE_ID.equals(bundleId) || XtendContainerInitializer.XTEXT_XTEND2_LIB_BUNDLE_ID.equals(bundleId)) {
                    extraAttributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)this.calculateJavadocURL())};
                }
                cpEntries.add(JavaCore.newLibraryEntry((IPath)bundlePath, (IPath)sourceBundlePath, null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])extraAttributes, (boolean)false));
            }
        }

        private String calculateJavadocURL() {
            Version xtend2version = Xtend2Activator.getInstance().getBundle().getVersion();
            StringBuilder builder = new StringBuilder("http://download.eclipse.org/modeling/tmf/xtext/javadoc/");
            builder.append(xtend2version.getMajor()).append(".");
            builder.append(xtend2version.getMinor()).append(".");
            builder.append(xtend2version.getMicro()).append("/");
            return builder.toString();
        }

        private IPath findBundle(String bundleId) {
            Bundle bundle = Platform.getBundle((String)bundleId);
            if (bundle != null) {
                File bundleFile = null;
                try {
                    bundleFile = FileLocator.getBundleFile((Bundle)bundle);
                    URL binFolderURL = FileLocator.find((Bundle)bundle, (IPath)new Path("bin"), null);
                    Path path = binFolderURL != null ? new Path(FileLocator.toFileURL((URL)binFolderURL).getPath()) : new Path(bundleFile.getAbsolutePath());
                    if (!path.isAbsolute()) {
                        path = path.makeAbsolute();
                    }
                    return path;
                }
                catch (IOException e) {
                    LOG.error((Object)("Can't resolve bundle '" + bundleId + "'"), (Throwable)e);
                }
            }
            return null;
        }

        public String getDescription() {
            return Messages.XtendClasspathContainer_Description;
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return this.containerPath;
        }
    }
}

