/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.builder;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.builder.BuilderParticipant;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xtend2.ui.builder.SourceRelativeFileSystemAccess;

public class XtendBuilderParticipant
extends BuilderParticipant {
    private static Logger LOGGER = Logger.getLogger(XtendBuilderParticipant.class);
    @Inject
    private IStorage2UriMapper mapper;

    protected void handleChangedContents(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, EclipseResourceFileSystemAccess2 fileSystemAccess) throws CoreException {
        if (!this.getResourceServiceProvider().canHandle(delta.getUri())) {
            return;
        }
        Resource resource = context.getResourceSet().getResource(delta.getUri(), true);
        if (this.shouldGenerate(resource, context)) {
            try {
                this.registerCurrentSourceFolder(delta, fileSystemAccess);
                this.getGenerator().doGenerate(resource, (IFileSystemAccess)fileSystemAccess);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof CoreException) {
                    throw (CoreException)e.getCause();
                }
                throw e;
            }
        }
    }

    protected void registerCurrentSourceFolder(IResourceDescription.Delta delta, EclipseResourceFileSystemAccess2 fileSystemAccess) {
        if (fileSystemAccess instanceof SourceRelativeFileSystemAccess) {
            try {
                Iterable storages = this.mapper.getStorages(delta.getUri());
                for (Pair pair : storages) {
                    IPackageFragmentRoot[] roots;
                    IJavaProject javaProject = JavaCore.create((IProject)((IProject)pair.getSecond()));
                    IResource first = (IResource)pair.getFirst();
                    IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getPackageFragmentRoots();
                    int n = roots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource underlyingResource;
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                        if (root.getKind() == 1 && (underlyingResource = root.getUnderlyingResource()) instanceof IFolder && underlyingResource.contains((ISchedulingRule)first)) {
                            ((SourceRelativeFileSystemAccess)fileSystemAccess).setCurrentSource((IFolder)underlyingResource);
                            return;
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

