/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportManager {
    private Map<String, String> imports = Maps.newHashMap();
    private boolean organizeImports;
    private String seedSimpleName;
    private Pattern JAVA_LANG_PACK = Pattern.compile("java\\.lang\\.[\\w]+");

    public ImportManager(boolean organizeImports) {
        this(organizeImports, null);
    }

    public ImportManager(boolean organizeImports, String seedSimpleName) {
        this.organizeImports = organizeImports;
        this.seedSimpleName = seedSimpleName;
    }

    public void appendTypeRef(JvmTypeReference typeRef, StringBuilder builder) {
        if (typeRef instanceof JvmParameterizedTypeReference) {
            JvmType type = typeRef.getType();
            this.appendType(type, builder);
            EList arguments = ((JvmParameterizedTypeReference)typeRef).getArguments();
            if (!arguments.isEmpty()) {
                builder.append("<");
                Iterator iterator = arguments.iterator();
                while (iterator.hasNext()) {
                    JvmTypeReference jvmTypeReference = (JvmTypeReference)iterator.next();
                    this.appendTypeRef(jvmTypeReference, builder);
                    if (!iterator.hasNext()) continue;
                    builder.append(",");
                }
                builder.append(">");
            }
        } else if (typeRef instanceof JvmWildcardTypeReference) {
            builder.append("?");
            Iterator iterator = ((JvmWildcardTypeReference)typeRef).getConstraints().iterator();
            while (iterator.hasNext()) {
                JvmTypeConstraint constraint = (JvmTypeConstraint)iterator.next();
                if (constraint instanceof JvmUpperBound) {
                    builder.append(" extends ");
                } else {
                    builder.append(" super ");
                }
                this.appendTypeRef(constraint.getTypeReference(), builder);
                if (!iterator.hasNext()) continue;
                builder.append(" & ");
            }
        } else if (typeRef instanceof JvmGenericArrayTypeReference) {
            JvmGenericArrayTypeReference reference = (JvmGenericArrayTypeReference)typeRef;
            this.appendTypeRef(reference.getComponentType(), builder);
            builder.append("[]");
        } else if (typeRef instanceof JvmAnyTypeReference) {
            this.appendType(typeRef.getType(), builder);
        } else {
            throw new IllegalArgumentException(typeRef == null ? null : typeRef.toString());
        }
    }

    public void appendType(JvmType type, StringBuilder builder) {
        if (type instanceof JvmPrimitiveType || type instanceof JvmVoid || type instanceof JvmTypeParameter) {
            builder.append(type.getQualifiedName('.'));
        } else if (type instanceof JvmArrayType) {
            this.appendTypeRef(((JvmArrayType)type).getComponentType(), builder);
            builder.append("[]");
        } else {
            String qn = type.getQualifiedName('.');
            String simpleName = type.getSimpleName();
            if (this.JAVA_LANG_PACK.matcher(qn).matches() || Strings.equal((String)qn, (String)simpleName)) {
                builder.append(simpleName);
            } else if (!this.organizeImports || simpleName.equals(this.seedSimpleName)) {
                builder.append(qn);
            } else if (this.imports.containsKey(simpleName)) {
                if (qn.equals(this.imports.get(simpleName))) {
                    builder.append(simpleName);
                } else {
                    builder.append(qn);
                }
            } else {
                this.imports.put(simpleName, qn);
                builder.append(simpleName);
            }
        }
    }

    public List<String> getImports() {
        ArrayList result = Lists.newArrayList(this.imports.values());
        Collections.sort(result);
        return result;
    }
}

