/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ecoreInference;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.XtextSwitch;
import org.eclipse.xtext.xtext.ecoreInference.EClassifierInfo;
import org.eclipse.xtext.xtext.ecoreInference.EClassifierInfos;

final class ElementTypeCalculator
extends XtextSwitch<EClassifier>
implements Function<AbstractElement, EClassifier> {
    private final EClassifierInfos classifierInfos;

    ElementTypeCalculator(EClassifierInfos classifierInfos) {
        this.classifierInfos = classifierInfos;
    }

    @Override
    public EClassifier caseKeyword(Keyword object) {
        EDataType eString = GrammarUtil.findEString(GrammarUtil.getGrammar(object));
        if (eString != null) {
            return eString;
        }
        return EcorePackage.Literals.ESTRING;
    }

    @Override
    public EClassifier caseTypeRef(TypeRef object) {
        if (object.getClassifier() == null) {
            if (object.getMetamodel() == null || object.getMetamodel().getEPackage() == null) {
                return null;
            }
            String name = GrammarUtil.getTypeRefName(object);
            if (Strings.isEmpty((String)name)) {
                return null;
            }
            EClassifierInfo info = this.classifierInfos.getInfo(object.getMetamodel(), name);
            if (info != null) {
                object.setClassifier(info.getEClassifier());
            }
        }
        return object.getClassifier();
    }

    @Override
    public EClassifier caseAbstractRule(AbstractRule object) {
        if (object.getType() != null) {
            return (EClassifier)this.doSwitch(object.getType());
        }
        return null;
    }

    @Override
    public EClassifier caseCompoundElement(CompoundElement object) {
        if (object.getElements().size() != 1) {
            return null;
        }
        return (EClassifier)this.doSwitch((EObject)object.getElements().get(0));
    }

    @Override
    public EClassifier caseRuleCall(RuleCall ruleCall) {
        if (ruleCall.getRule() != null) {
            return (EClassifier)this.doSwitch(ruleCall.getRule());
        }
        return null;
    }

    @Override
    public EClassifier caseAlternatives(Alternatives object) {
        LinkedHashSet types = Sets.newLinkedHashSet();
        for (AbstractElement group : object.getElements()) {
            types.add((EClassifier)this.doSwitch(group));
        }
        try {
            return this.classifierInfos.getCompatibleTypeNameOf(types, true);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public EClassifier caseCrossReference(CrossReference object) {
        return (EClassifier)this.doSwitch(object.getType());
    }

    public EClassifier apply(AbstractElement param) {
        return (EClassifier)this.doSwitch(param);
    }
}

