/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.service;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.binder.LinkedBindingBuilder;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.apache.log4j.Logger;
import org.eclipse.xtext.service.BindModule;
import org.eclipse.xtext.service.SingletonBinding;

public abstract class MethodBasedModule
implements Module {
    private static Logger LOGGER = Logger.getLogger(BindModule.class);
    private final Method method;
    private final Object owner;

    protected MethodBasedModule(Method method, Object owner) {
        this.method = method;
        this.owner = owner;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void configure(Binder binder) {
        Type key = this.getKeyType();
        if (this.isClassBinding()) {
            Class value = (Class)this.invokeMethod(new Object[0]);
            if (value != null && !Void.class.equals((Object)value)) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Adding binding from " + String.valueOf(key) + " to " + value.getName() + ". Declaring Method was '" + this.getMethod().toGenericString() + "' in Module " + this.getClass().getName()));
                }
                LinkedBindingBuilder bind = binder.bind(Key.get((Type)key));
                if (!key.equals(value)) {
                    this.bindToClass((LinkedBindingBuilder<Object>)bind, value);
                }
                if (this.isEager()) {
                    bind.asEagerSingleton();
                } else if (this.isSingleton()) {
                    bind.in(Scopes.SINGLETON);
                }
            }
        } else {
            Object instance = this.invokeMethod(new Object[0]);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Adding binding from " + this.getMethod().getReturnType().getName() + " to instance " + instance.toString() + ". Declaring Method was '" + this.getMethod().toGenericString() + "' in Module " + this.getClass().getName()));
            }
            LinkedBindingBuilder bind = binder.bind(Key.get((Type)key));
            this.bindToInstance((LinkedBindingBuilder<Object>)bind, instance);
        }
    }

    protected void bindToClass(LinkedBindingBuilder<Object> bind, Class<?> value) {
        bind.to(value);
    }

    protected void bindToInstance(LinkedBindingBuilder<Object> bind, Object instance) {
        bind.toInstance(instance);
    }

    protected boolean isSame(Type typeA, Type typeB) {
        return typeA.equals(typeB);
    }

    public Type getKeyType() {
        Type genericReturnType = this.getMethod().getGenericReturnType();
        if (this.isClassBinding()) {
            Type type = genericReturnType;
            if (!(type instanceof ParameterizedType)) {
                throw this.throwIllegalReturnTypeDeclaration(this.getMethod());
            }
            return this.getFirstTypeParameter((ParameterizedType)type);
        }
        return genericReturnType;
    }

    protected Type getFirstTypeParameter(ParameterizedType type) {
        Type firstParam = type.getActualTypeArguments()[0];
        if (firstParam instanceof WildcardType) {
            return ((WildcardType)firstParam).getUpperBounds()[0];
        }
        return firstParam;
    }

    protected IllegalStateException throwIllegalReturnTypeDeclaration(Method method) {
        return new IllegalStateException("return type of " + method.getName() + " should be declared with wildcard and upperbound (i.e. Class<? extends IScopeProvider>)");
    }

    public boolean isClassBinding() {
        return Class.class.equals(this.getMethod().getReturnType());
    }

    public boolean isEager() {
        SingletonBinding binding = this.getMethod().getAnnotation(SingletonBinding.class);
        if (binding != null) {
            return binding.eager();
        }
        return false;
    }

    public boolean isSingleton() {
        return this.getMethod().getAnnotation(SingletonBinding.class) != null;
    }

    public Object invokeMethod(Object ... parameters) {
        try {
            this.getMethod().setAccessible(true);
            return this.getMethod().invoke(this.owner, parameters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

