/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractRootTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.NoTypeResult;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.RootTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.TypeExpectation;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class AnnotationValueTypeComputationState
extends AbstractRootTypeComputationState {
    private final JvmAnnotationValue annotationValue;
    private final XExpression expression;

    public AnnotationValueTypeComputationState(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmAnnotationValue annotationValue, XExpression expression) {
        super(resolvedTypes, featureScopeSession);
        this.annotationValue = annotationValue;
        this.expression = expression;
    }

    @Override
    protected List<AbstractTypeExpectation> getExpectations(AbstractTypeComputationState actualState, boolean returnType) {
        LightweightTypeReference type = this.getExpectedType();
        AbstractTypeExpectation result = returnType ? new TypeExpectation(type, actualState, returnType) : new RootTypeExpectation(type, actualState);
        return Collections.singletonList(result);
    }

    @Override
    protected LightweightTypeReference getExpectedType() {
        JvmOperation operation = this.annotationValue.getOperation();
        LightweightTypeReference result = this.getResolvedTypes().getActualType((JvmIdentifiableElement)operation);
        if (result != null && result.isArray()) {
            return result.getComponentType();
        }
        return result;
    }

    @Override
    protected XExpression getRootExpression() {
        return this.expression;
    }

    @Override
    protected ITypeComputationResult createNoTypeResult() {
        return new NoTypeResult((EObject)this.annotationValue, this.resolvedTypes.getReferenceOwner());
    }
}

