/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.editor;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.generator.trace.IEclipseTrace;
import org.eclipse.xtext.ui.generator.trace.ILocationInEclipseResource;
import org.eclipse.xtext.ui.generator.trace.ITraceForStorageProvider;

public class XbaseEditorInputRedirector {
    private static final Logger LOG = Logger.getLogger(XbaseEditorInputRedirector.class);
    @Inject
    private ITraceForStorageProvider traceInformation;
    @Inject
    private LanguageInfo languageInfo;
    @Inject
    private FileExtensionProvider fileExtensionProvider;

    public ITypeRoot getTypeRoot(IEditorInput editorInput) {
        IJavaElement adapter = (IJavaElement)editorInput.getAdapter(IJavaElement.class);
        return adapter instanceof ITypeRoot ? (ITypeRoot)adapter : null;
    }

    public IEditorInput findOriginalSourceForOuputFolderCopy(IEditorInput input) {
        block12: {
            IFile resource = ResourceUtil.getFile((IEditorInput)input);
            if (resource == null) {
                return input;
            }
            try {
                IJavaProject project;
                if (this.fileExtensionProvider.isValid(resource.getFullPath().getFileExtension()) && (project = JavaCore.create((IProject)resource.getProject())).exists()) {
                    int n;
                    if (project.getOutputLocation().isPrefixOf(resource.getFullPath())) {
                        IPath relative = resource.getFullPath().removeFirstSegments(project.getOutputLocation().segmentCount());
                        IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
                        int n2 = iPackageFragmentRootArray.length;
                        n = 0;
                        while (n < n2) {
                            IPackageFragmentRoot root = iPackageFragmentRootArray[n];
                            if (root.getKind() == 1) {
                                IPath fullPath = root.getCorrespondingResource().getProjectRelativePath().append(relative);
                                IFile newFile = resource.getProject().getFile(fullPath);
                                if (newFile.exists()) {
                                    return new FileEditorInput(newFile);
                                }
                            }
                            ++n;
                        }
                    }
                    IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
                    n = iClasspathEntryArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IClasspathEntry classpathEntry = iClasspathEntryArray[n3];
                        if (classpathEntry.getEntryKind() == 3 && classpathEntry.getOutputLocation() != null && classpathEntry.getOutputLocation().isPrefixOf(resource.getFullPath())) {
                            IPath relative = resource.getFullPath().removeFirstSegments(classpathEntry.getOutputLocation().segmentCount());
                            IPackageFragmentRoot[] iPackageFragmentRootArray = project.findPackageFragmentRoots(classpathEntry);
                            int n4 = iPackageFragmentRootArray.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                IPackageFragmentRoot root = iPackageFragmentRootArray[n5];
                                IPath fullPath = root.getCorrespondingResource().getProjectRelativePath().append(relative);
                                IFile newFile = resource.getProject().getFile(fullPath);
                                if (newFile.exists()) {
                                    return new FileEditorInput(newFile);
                                }
                                ++n5;
                            }
                        }
                        ++n3;
                    }
                }
            }
            catch (JavaModelException e) {
                if (e.isDoesNotExist()) break block12;
                LOG.error((Object)"Error finding the original source for the editor input", (Throwable)e);
            }
        }
        return input;
    }

    public IEditorInput findOriginalSource(IEditorInput input) {
        IFile resource = ResourceUtil.getFile((IEditorInput)input);
        if (resource == null) {
            return input;
        }
        IEditorInput original = this.findOriginalSourceForOuputFolderCopy(input);
        if (original != input) {
            return original;
        }
        IEclipseTrace trace = (IEclipseTrace)this.traceInformation.getTraceToSource((Object)resource);
        if (trace == null) {
            return input;
        }
        for (ILocationInEclipseResource candidate : trace.getAllAssociatedLocations()) {
            IStorage storage;
            if (!this.languageInfo.equals((Object)candidate.getLanguage()) || (storage = (IStorage)candidate.getPlatformResource()) == null) continue;
            return EditorUtils.createEditorInput((IStorage)storage);
        }
        return input;
    }

    public IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        Preconditions.checkNotNull((Object)element, (Object)"Couldn't find source package fragment root.");
        return (IPackageFragmentRoot)element.getAncestor(3);
    }
}

