/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import org.eclipse.emf.mwe.utils.ProjectMapping;
import org.eclipse.emf.mwe.utils.StandaloneSetup;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xtext.generator.IGuiceAwareGeneratorComponent;
import org.eclipse.xtext.xtext.generator.model.project.ISubProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;

public class XtextGeneratorStandaloneSetup
implements IGuiceAwareGeneratorComponent {
    @Inject
    private IXtextProjectConfig projectConfig;
    private boolean scanClasspath = true;

    @Override
    public void initialize(Injector injector) {
        injector.injectMembers((Object)this);
        this.setup();
    }

    private void setup() {
        StandaloneSetup delegate = new StandaloneSetup();
        delegate.setScanClassPath(this.scanClasspath);
        for (Pair<String, String> mapping : this.getProjectMappings()) {
            ProjectMapping projectMapping = new ProjectMapping();
            projectMapping.setProjectName((String)mapping.getKey());
            projectMapping.setPath((String)mapping.getValue());
            delegate.addProjectMapping(projectMapping);
        }
    }

    private Iterable<Pair<String, String>> getProjectMappings() {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        for (ISubProjectConfig iSubProjectConfig : this.projectConfig.getEnabledProjects()) {
            if (iSubProjectConfig.getName() == null || iSubProjectConfig.getRoot() == null) continue;
            result.add((Pair<String, String>)Pair.of((Object)iSubProjectConfig.getName(), (Object)iSubProjectConfig.getRoot().getPath()));
        }
        return result;
    }

    public boolean isScanClasspath() {
        return this.scanClasspath;
    }

    public void setScanClasspath(boolean scanClasspath) {
        this.scanClasspath = scanClasspath;
    }
}

