/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccessDiff;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionDiffBuilder;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.TextRegionAccessBuilder;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringBasedTextRegionAccessDiffBuilder;
import org.eclipse.xtext.ide.serializer.IEmfResourceChange;
import org.eclipse.xtext.ide.serializer.hooks.IReferenceUpdater;
import org.eclipse.xtext.ide.serializer.hooks.IUpdatableReference;
import org.eclipse.xtext.ide.serializer.impl.ChangeTreeProvider;
import org.eclipse.xtext.ide.serializer.impl.EObjectDescriptionDeltaProvider;
import org.eclipse.xtext.ide.serializer.impl.PartialSerializer;
import org.eclipse.xtext.ide.serializer.impl.ReferenceUpdaterContext;
import org.eclipse.xtext.ide.serializer.impl.RegionDiffFormatter;
import org.eclipse.xtext.ide.serializer.impl.RelatedResourceUpdater;
import org.eclipse.xtext.ide.serializer.impl.ResourceLifecycleManager;
import org.eclipse.xtext.ide.serializer.impl.TextDocumentChange;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.IAcceptor;

public class RelatedXtextResourceUpdater
extends RelatedResourceUpdater {
    @Inject
    private ChangeTreeProvider changeTreeProvider;
    @Inject
    private RegionDiffFormatter formatter;
    @Inject
    private IReferenceUpdater referenceUpdater;
    @Inject
    private PartialSerializer serializer;
    @Inject
    private Provider<TextRegionAccessBuilder> textRegionBuilderProvider;
    @Inject
    private ResourceLifecycleManager lifecycleManager;

    @Override
    public void applyChange(EObjectDescriptionDeltaProvider.Deltas deltas, IAcceptor<IEmfResourceChange> changeAcceptor) {
        XtextResource res = (XtextResource)this.lifecycleManager.openAndApplyReferences(this.getResourceSet(), this.getResource());
        if (!this.referenceUpdater.isAffected(deltas, this.getResource())) {
            return;
        }
        ITextRegionAccess base = ((TextRegionAccessBuilder)this.textRegionBuilderProvider.get()).forNodeModel(res).create();
        StringBasedTextRegionAccessDiffBuilder rewriter = new StringBasedTextRegionAccessDiffBuilder(base);
        ReferenceUpdaterContext context = new ReferenceUpdaterContext(deltas, (ITextRegionDiffBuilder)rewriter, this.getResource());
        this.referenceUpdater.update(context);
        if (!context.getModifications().isEmpty()) {
            ChangeRecorder rec = this.createChangeRecorder(res);
            try {
                for (Runnable run : context.getModifications()) {
                    run.run();
                }
                ChangeDescription recording = rec.endRecording();
                ResourceSet rs = res.getResourceSet();
                ChangeTreeProvider.ResourceSetRecording tree = this.changeTreeProvider.createChangeTree(rs, Collections.emptyList(), recording);
                ChangeTreeProvider.ResourceRecording recordedResource = tree.getRecordedResource((Resource)res);
                if (recordedResource != null) {
                    this.serializer.serializeChanges(recordedResource, (ITextRegionDiffBuilder)rewriter);
                }
            }
            finally {
                rec.dispose();
            }
        }
        for (IUpdatableReference upd : context.getUpdatableReferences()) {
            this.referenceUpdater.updateReference((ITextRegionDiffBuilder)rewriter, upd);
        }
        ITextRegionAccessDiff rewritten = rewriter.create();
        List<ITextReplacement> rep = this.formatter.format((ITextRegionAccess)rewritten);
        TextDocumentChange change = new TextDocumentChange(rewritten, this.getResource().getUri(), rep);
        changeAcceptor.accept((Object)change);
    }

    protected ChangeRecorder createChangeRecorder(XtextResource res) {
        return new ChangeRecorder((EObject)res.getContents().get(0));
    }

    @Override
    public void unload() {
    }
}

