/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.rename;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ServerRefactoringIssueAcceptor
implements RefactoringIssueAcceptor {
    private List<Issue> issues = new ArrayList<Issue>();

    @Override
    public void add(RefactoringIssueAcceptor.Severity severity, String message, URI uri, ResourceSet resourceSet) {
        this.addIssue(severity, message);
    }

    @Override
    public void add(RefactoringIssueAcceptor.Severity severity, String message, URI resourceUri) {
        this.addIssue(severity, message);
    }

    @Override
    public void add(RefactoringIssueAcceptor.Severity severity, String message, EObject element) {
        this.addIssue(severity, message);
    }

    @Override
    public void add(RefactoringIssueAcceptor.Severity severity, String message, EObject element, ITextRegion region) {
        this.addIssue(severity, message);
    }

    @Override
    public void add(RefactoringIssueAcceptor.Severity severity, String message, Exception exc, Logger log) {
        this.addIssue(severity, message);
    }

    @Override
    public void add(RefactoringIssueAcceptor.Severity severity, String message, Object ... params) {
        Issue issue = new Issue();
        issue.severity = severity;
        issue.message = message;
        this.issues.add(issue);
    }

    protected boolean addIssue(RefactoringIssueAcceptor.Severity severity, String message) {
        Issue issue = new Issue();
        issue.severity = severity;
        issue.message = message;
        return this.issues.add(issue);
    }

    public RefactoringIssueAcceptor.Severity getMaximumSeverity() {
        if (this.issues.size() > 0) {
            Issue minBySeverity = (Issue)IterableExtensions.minBy(this.issues, i -> i.severity);
            RefactoringIssueAcceptor.Severity severity = null;
            if (minBySeverity != null) {
                severity = minBySeverity.severity;
            }
            return severity;
        }
        return RefactoringIssueAcceptor.Severity.OK;
    }

    public ResponseError toResponseError() {
        RefactoringIssueAcceptor.Severity maxSeverity = this.getMaximumSeverity();
        ResponseError responseError = new ResponseError();
        responseError.setMessage(this.getMessageBySeverity(maxSeverity));
        responseError.setCode(this.getCodeBySeverity(maxSeverity));
        List bySeverity = IterableExtensions.sortBy(this.issues, i -> i.severity);
        List messages = Lists.transform((List)Lists.reverse((List)bySeverity), i -> i.message);
        responseError.setData((Object)Joiner.on((String)"\n").join((Iterable)messages));
        return responseError;
    }

    protected int getCodeBySeverity(RefactoringIssueAcceptor.Severity maxSeverity) {
        if (maxSeverity != null) {
            switch (maxSeverity) {
                case OK: {
                    return 0;
                }
                case INFO: {
                    return 0;
                }
                case WARNING: {
                    return 0;
                }
                case ERROR: {
                    return ResponseErrorCode.UnknownErrorCode.getValue();
                }
                case FATAL: {
                    return ResponseErrorCode.UnknownErrorCode.getValue();
                }
            }
            return 0;
        }
        return 0;
    }

    protected String getMessageBySeverity(RefactoringIssueAcceptor.Severity maxSeverity) {
        if (maxSeverity != null) {
            switch (maxSeverity) {
                case OK: {
                    return "Refactoring is possible";
                }
                case INFO: {
                    return "Refactoring is possible";
                }
                case WARNING: {
                    return "Refactoring could cause issues";
                }
                case ERROR: {
                    return "Refactoring has errors";
                }
                case FATAL: {
                    return "Refactoring cannot be performed";
                }
            }
            return null;
        }
        return null;
    }

    public void checkSeverity() {
        if (this.getMaximumSeverity().compareTo(RefactoringIssueAcceptor.Severity.WARNING) < 0) {
            throw new ResponseErrorException(this.toResponseError());
        }
    }

    public static class Issue {
        private RefactoringIssueAcceptor.Severity severity;
        private String message;
    }
}

