/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.buildpath;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtend.ide.buildpath.XtendClasspathContainer;
import org.eclipse.xtend.ide.internal.XtendActivator;

public class XtendContainerInitializer
extends ClasspathContainerInitializer {
    public static final Path XTEND_LIBRARY_PATH = new Path("org.eclipse.xtend.XTEND_CONTAINER");

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (this.isXtendPath(containerPath)) {
            XtendClasspathContainer container = new XtendClasspathContainer(containerPath);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(final IPath containerPath, final IJavaProject project, final IClasspathContainer containerSuggestion) throws CoreException {
        super.requestClasspathContainerUpdate(containerPath, project, containerSuggestion);
        new Job("Classpath container update"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{containerSuggestion}, (IProgressMonitor)monitor);
                }
                catch (CoreException ex) {
                    return new Status(4, XtendActivator.getInstance().getBundle().getSymbolicName(), 0, "Classpath container update failed", (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private boolean isXtendPath(IPath containerPath) {
        return XTEND_LIBRARY_PATH.equals((Object)containerPath);
    }
}

