/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.INodeReference;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.nodemodel.impl.InternalNodeModelUtils;
import org.eclipse.xtext.nodemodel.impl.RootNode;
import org.eclipse.xtext.util.LineAndColumn;

public class NodeModelUtils
extends InternalNodeModelUtils {
    public static ILeafNode findLeafNodeAtOffset(INode node, int leafNodeOffset) {
        return node.utils().findLeafNodeAtOffset(node, leafNodeOffset);
    }

    public static LineAndColumn getLineAndColumn(INode anyNode, int documentOffset) {
        return anyNode.utils().getLineAndColumn(anyNode, documentOffset);
    }

    private static LineAndColumn internalGetLineAndColumn(INode anyNode, int documentOffset) {
        return InternalNodeModelUtils.getLineAndColumn(anyNode, documentOffset);
    }

    public static ICompositeNode getNode(EObject object) {
        if (object == null) {
            return null;
        }
        if (object instanceof INodeReference) {
            return ((INodeReference)object).getNode();
        }
        Adapter adapter = EcoreUtil.getExistingAdapter((Notifier)object, ICompositeNode.class);
        if (adapter instanceof INodeReference) {
            return ((INodeReference)adapter).getNode();
        }
        return (ICompositeNode)adapter;
    }

    public static List<INode> findNodesForFeature(EObject semanticObject, EStructuralFeature structuralFeature) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor(semanticObject);
        if (node != null) {
            return node.utils().findNodesForFeature(semanticObject, node, structuralFeature);
        }
        return Collections.emptyList();
    }

    public static ICompositeNode findActualNodeFor(EObject semanticObject) {
        ICompositeNode node = NodeModelUtils.getNode(semanticObject);
        if (node != null) {
            return node.utils().findActualNodeEnclosing(node);
        }
        return node;
    }

    public static EObject findActualSemanticObjectFor(INode node) {
        if (node == null) {
            return null;
        }
        return node.utils().findActualSemanticObjectFor(node);
    }

    public static String compactDump(INode node, boolean showHidden) {
        if (node == null) {
            return "(null)";
        }
        return node.utils().compactDump(node, showHidden);
    }

    public static String getTokenText(INode node) {
        return node.utils().getTokenText(node);
    }

    public static ParserRule getEntryParserRule(INode node) {
        return node.utils().getEntryParserRule(node);
    }

    public static interface Implementation {
        /*
         * Unable to fully structure code
         */
        default public ILeafNode findLeafNodeAtOffset(INode node, int leafNodeOffset) {
            block7: {
                localNode = node;
                while (!(localNode instanceof AbstractNode)) {
                    localNode = localNode.getParent();
                }
                offset = localNode.getTotalOffset();
                length = localNode.getTotalLength();
                iterator = ((AbstractNode)localNode).basicIterator();
                if (leafNodeOffset <= (offset + length) / 2) ** GOTO lbl29
                while (iterator.hasPrevious()) {
                    previous = iterator.previous();
                    previousOffset = previous.getTotalOffset();
                    if (!this.intersects(previousOffset, previousLength = previous.getTotalLength(), leafNodeOffset)) {
                        if (previousOffset + previousLength <= leafNodeOffset) {
                            return null;
                        }
                        iterator.prune();
                        continue;
                    }
                    if (!(previous instanceof ILeafNode)) continue;
                    return (ILeafNode)previous;
                }
                break block7;
lbl-1000:
                // 1 sources

                {
                    next = iterator.next();
                    nextOffset = next.getTotalOffset();
                    if (!this.intersects(nextOffset, nextLength = next.getTotalLength(), leafNodeOffset)) {
                        if (nextOffset > leafNodeOffset) {
                            return null;
                        }
                        iterator.prune();
                        continue;
                    }
                    if (!(next instanceof ILeafNode)) continue;
                    return (ILeafNode)next;
lbl29:
                    // 3 sources

                    ** while (iterator.hasNext())
                }
            }
            return null;
        }

        default public LineAndColumn getLineAndColumn(INode anyNode, int documentOffset) {
            if (anyNode.getParent() == null && !(anyNode instanceof RootNode)) {
                return LineAndColumn.from((int)1, (int)1);
            }
            return NodeModelUtils.internalGetLineAndColumn(anyNode, documentOffset);
        }

        private boolean intersects(int offset, int length, int lookupOffset) {
            return offset <= lookupOffset && offset + length > lookupOffset;
        }

        default public List<INode> findNodesForFeature(EObject semanticElement, INode node, EStructuralFeature structuralFeature) {
            if (structuralFeature == null) {
                return Collections.emptyList();
            }
            ArrayList result = Lists.newArrayList();
            String featureName = structuralFeature.getName();
            Iterator iterator = node.getAsTreeIterable().iterator();
            while (iterator.hasNext()) {
                Assignment assignment;
                INode child = (INode)iterator.next();
                EObject grammarElement = child.getGrammarElement();
                if (grammarElement == null) continue;
                if (grammarElement instanceof Action) {
                    Action action = (Action)grammarElement;
                    if (child.getSemanticElement() == semanticElement) {
                        child = (INode)iterator.next();
                        if (featureName.equals(action.getFeature())) {
                            result.add(child);
                        }
                    } else {
                        INode firstChild = ((ICompositeNode)child).getFirstChild();
                        while (firstChild.getGrammarElement() instanceof Action) {
                            firstChild = ((ICompositeNode)firstChild).getFirstChild();
                        }
                        EObject firstChildGrammarElement = firstChild.getGrammarElement();
                        Assignment assignment2 = GrammarUtil.containingAssignment(firstChildGrammarElement);
                        if (assignment2 != null && featureName.equals(assignment2.getFeature())) {
                            result.add(child);
                        }
                    }
                    iterator.prune();
                    continue;
                }
                if (child == node || (assignment = GrammarUtil.containingAssignment(grammarElement)) == null) continue;
                if (featureName.equals(assignment.getFeature())) {
                    result.add(child);
                }
                iterator.prune();
            }
            return result;
        }

        default public ICompositeNode findActualNodeEnclosing(ICompositeNode node) {
            while (GrammarUtil.containingAssignment(node.getGrammarElement()) == null) {
                ICompositeNode parent = node.getParent();
                if (parent == null || parent.hasDirectSemanticElement() || GrammarUtil.isEObjectFragmentRuleCall(parent.getGrammarElement())) break;
                node = parent;
            }
            return node;
        }

        default public EObject findActualSemanticObjectFor(INode node) {
            EObject result;
            if (node == null) {
                return null;
            }
            if (node.hasDirectSemanticElement()) {
                return node.getSemanticElement();
            }
            EObject grammarElement = node.getGrammarElement();
            ICompositeNode parent = node.getParent();
            if (grammarElement == null) {
                return this.findActualSemanticObjectFor(parent);
            }
            Assignment assignment = GrammarUtil.containingAssignment(grammarElement);
            if (assignment != null) {
                EObject result2;
                if (GrammarUtil.isEObjectFragmentRule(GrammarUtil.containingRule(assignment)) && (result2 = this.findActualSemanticObjectInChildren(node, grammarElement)) != null) {
                    return result2;
                }
                if (parent.hasDirectSemanticElement()) {
                    return this.findActualSemanticObjectFor(parent);
                }
                INode sibling = parent.getFirstChild();
                while (!sibling.equals(node)) {
                    EObject siblingGrammarElement = sibling.getGrammarElement();
                    if (siblingGrammarElement != null && GrammarUtil.containingAssignment(siblingGrammarElement) == null) {
                        if (GrammarUtil.isEObjectRuleCall(siblingGrammarElement)) {
                            return this.findActualSemanticObjectFor(sibling);
                        }
                        if (siblingGrammarElement.eClass() == XtextPackage.Literals.ACTION) {
                            return this.findActualSemanticObjectFor(sibling);
                        }
                    }
                    sibling = sibling.getNextSibling();
                }
            } else if (!GrammarUtil.isEObjectFragmentRuleCall(grammarElement) && (result = this.findActualSemanticObjectInChildren(node, grammarElement)) != null) {
                return result;
            }
            return this.findActualSemanticObjectFor(parent);
        }

        private EObject findActualSemanticObjectInChildren(INode node, EObject grammarElement) {
            if (node.hasDirectSemanticElement()) {
                return node.getSemanticElement();
            }
            AbstractRule rule = null;
            if (grammarElement instanceof RuleCall) {
                rule = ((RuleCall)grammarElement).getRule();
            } else if (grammarElement instanceof AbstractRule) {
                rule = (AbstractRule)grammarElement;
            }
            if (rule instanceof ParserRule && !GrammarUtil.isDatatypeRule(rule) && node instanceof ICompositeNode) {
                for (INode child : ((ICompositeNode)node).getChildren()) {
                    EObject result;
                    RuleCall childRuleCall;
                    if (!(child instanceof ICompositeNode)) continue;
                    EObject childGrammarElement = child.getGrammarElement();
                    if (childGrammarElement instanceof Action) {
                        EObject result2 = this.findActualSemanticObjectInChildren(child, childGrammarElement);
                        if (result2 == null) continue;
                        return result2;
                    }
                    if (!(childGrammarElement instanceof RuleCall) || !((childRuleCall = (RuleCall)childGrammarElement).getRule() instanceof ParserRule) || GrammarUtil.isDatatypeRule(childRuleCall.getRule()) || (result = this.findActualSemanticObjectInChildren(child, childRuleCall)) == null) continue;
                    return result;
                }
            }
            return null;
        }

        default public String compactDump(INode node, boolean showHidden) {
            StringBuilder result = new StringBuilder();
            try {
                this.compactDump(node, showHidden, "", result);
            }
            catch (IOException e) {
                return e.getMessage();
            }
            return result.toString();
        }

        private void compactDump(INode node, boolean showHidden, String prefix, Appendable result) throws IOException {
            if (!showHidden && node instanceof ILeafNode && ((ILeafNode)node).isHidden()) {
                return;
            }
            if (prefix.length() != 0) {
                result.append("\n");
                result.append(prefix);
            }
            if (node instanceof ICompositeNode) {
                if (node.getGrammarElement() != null) {
                    result.append(new GrammarElementTitleSwitch().showAssignments().doSwitch(node.getGrammarElement()));
                } else {
                    result.append("(unknown)");
                }
                String newPrefix = String.valueOf(prefix) + "  ";
                result.append(" {");
                for (INode child : ((ICompositeNode)node).getChildren()) {
                    this.compactDump(child, showHidden, newPrefix, result);
                }
                result.append("\n");
                result.append(prefix);
                result.append("}");
                SyntaxErrorMessage error = node.getSyntaxErrorMessage();
                if (error != null) {
                    result.append(" SyntaxError: [" + error.getIssueCode() + "] " + error.getMessage());
                }
            } else if (node instanceof ILeafNode) {
                if (((ILeafNode)node).isHidden()) {
                    result.append("hidden ");
                }
                if (node.getGrammarElement() != null) {
                    result.append(new GrammarElementTitleSwitch().showAssignments().doSwitch(node.getGrammarElement()));
                } else {
                    result.append("(unknown)");
                }
                result.append(" => '");
                result.append(node.getText());
                result.append("'");
                SyntaxErrorMessage error = node.getSyntaxErrorMessage();
                if (error != null) {
                    result.append(" SyntaxError: [" + error.getIssueCode() + "] " + error.getMessage());
                }
            } else if (node == null) {
                result.append("(null)");
            } else {
                result.append("unknown type ");
                result.append(node.getClass().getName());
            }
        }

        default public String getTokenText(INode node) {
            if (node instanceof ILeafNode) {
                return ((ILeafNode)node).getText();
            }
            StringBuilder builder = new StringBuilder(Math.max(node.getTotalLength(), 1));
            boolean hiddenSeen = false;
            for (ILeafNode leaf : node.getLeafNodes()) {
                if (!leaf.isHidden()) {
                    if (hiddenSeen && builder.length() > 0) {
                        builder.append(' ');
                    }
                    builder.append(leaf.getText());
                    hiddenSeen = false;
                    continue;
                }
                hiddenSeen = true;
            }
            return builder.toString();
        }

        default public ParserRule getEntryParserRule(INode node) {
            ICompositeNode root = node.getRootNode();
            EObject ge1 = root.getGrammarElement();
            if (ge1 instanceof ParserRule) {
                return (ParserRule)ge1;
            }
            if (ge1 instanceof Action) {
                INode firstChild = root.getFirstChild();
                while (firstChild.getGrammarElement() instanceof Action && firstChild instanceof CompositeNode) {
                    firstChild = ((CompositeNode)firstChild).getFirstChild();
                }
                EObject ge2 = firstChild.getGrammarElement();
                if (ge2 instanceof ParserRule) {
                    return (ParserRule)ge2;
                }
            }
            throw new IllegalStateException("No Root Parser Rule found; The Node Model is broken.");
        }

        public static enum Default implements Implementation
        {
            INSTANCE;

        }
    }
}

