/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.concurrent;

import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.util.concurrent.WrappingCancelableUnitOfWork;

public interface IReadAccess<State> {
    public <Result> Result readOnly(IUnitOfWork<Result, State> var1);

    default public <Result> Result tryReadOnly(IUnitOfWork<Result, State> work, Supplier<? extends Result> defaultResult) {
        if (work instanceof CancelableUnitOfWork) {
            return this.readOnly(new WrappingCancelableUnitOfWork<Result, State>(defaultResult, work));
        }
        return (Result)this.readOnly(state -> {
            if (state == null) {
                return defaultResult.get();
            }
            return work.exec(state);
        });
    }

    default public <Result> Result tryReadOnly(IUnitOfWork<Result, State> work) {
        return (Result)this.tryReadOnly(work, () -> null);
    }

    default public <Result> Result tryReadOnly(IUnitOfWork<Result, State> work, Supplier<? extends Result> defaultResult, Function<? super Exception, ? extends Result> exceptionHandler) {
        try {
            return this.tryReadOnly(work, defaultResult);
        }
        catch (Exception e) {
            return exceptionHandler.apply(e);
        }
    }

    public static interface Priority<State> {
        public <Result> Result priorityReadOnly(IUnitOfWork<Result, State> var1);

        default public <Result> Result tryPriorityReadOnly(IUnitOfWork<Result, State> work, Supplier<? extends Result> defaultResult) {
            if (work instanceof CancelableUnitOfWork) {
                return this.priorityReadOnly(new WrappingCancelableUnitOfWork<Result, State>(defaultResult, work));
            }
            return (Result)this.priorityReadOnly(state -> {
                if (state == null) {
                    return defaultResult.get();
                }
                return work.exec(state);
            });
        }

        default public <Result> Result tryPriorityReadOnly(IUnitOfWork<Result, State> work) {
            return (Result)this.tryPriorityReadOnly(work, () -> null);
        }

        default public <Result> Result tryPriorityReadOnly(IUnitOfWork<Result, State> work, Supplier<? extends Result> defaultResult, Function<? super Exception, ? extends Result> exceptionHandler) {
            try {
                return this.tryPriorityReadOnly(work, defaultResult);
            }
            catch (Exception e) {
                return exceptionHandler.apply(e);
            }
        }
    }
}

