/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.collect.ImmutableList;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class FilteringClassLoader
extends ClassLoader {
    private static final char DOT = '.';
    private static final char SLASH = '/';
    private final List<String> includes;
    private final List<String> resourceIncludes;

    public FilteringClassLoader(ClassLoader parent, List<String> includes) {
        super(parent);
        Functions.Function1 _function = it -> String.valueOf(it) + Character.valueOf('.');
        this.includes = ImmutableList.copyOf((Collection)ListExtensions.map(includes, (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> it.replace('.', '/');
        Functions.Function1 _function_2 = it -> String.valueOf(it) + Character.valueOf('/');
        this.resourceIncludes = ImmutableList.copyOf((Collection)ListExtensions.map((List)ListExtensions.map(includes, (Functions.Function1)_function_1), (Functions.Function1)_function_2));
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            ClassLoader _parent = ClassLoader.getSystemClassLoader().getParent();
            Class<?> _loadClass = null;
            if (_parent != null) {
                _loadClass = _parent.loadClass(name);
            }
            return _loadClass;
        }
        catch (Throwable _t) {
            if (!(_t instanceof ClassNotFoundException)) {
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            boolean _isValidClass = this.isValidClass(name);
            if (_isValidClass) {
                Class<?> result = super.loadClass(name, false);
                if (resolve) {
                    this.resolveClass(result);
                }
                return result;
            }
            throw new ClassNotFoundException(name);
        }
    }

    @Override
    public URL getResource(String name) {
        URL result;
        ClassLoader _parent = ClassLoader.getSystemClassLoader().getParent();
        URL _resource = null;
        if (_parent != null) {
            _resource = _parent.getResource(name);
        }
        if ((result = _resource) != null) {
            return result;
        }
        boolean _isValidResource = this.isValidResource(name);
        if (_isValidResource) {
            return super.getResource(name);
        }
        return null;
    }

    private boolean isValidClass(String name) {
        boolean _xblockexpression = false;
        for (String it : this.includes) {
            boolean _startsWith = name.startsWith(it);
            if (!_startsWith) continue;
            return true;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    private boolean isValidResource(String name) {
        boolean _xblockexpression = false;
        for (String it : this.resourceIncludes) {
            boolean _startsWith = name.startsWith(it);
            if (!_startsWith) continue;
            return true;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }
}

