/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.adapter;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandExecutionContextImpl;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xpand2.output.Output;
import org.eclipse.xpand2.output.PostProcessor;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.type.impl.java.JavaBeansMetaModel;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.Binding;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorFragment;
import org.eclipse.xtext.generator.IGeneratorFragmentExtension;
import org.eclipse.xtext.generator.IGeneratorFragmentExtension2;
import org.eclipse.xtext.generator.IGeneratorFragmentExtension3;
import org.eclipse.xtext.generator.IGeneratorFragmentExtension4;
import org.eclipse.xtext.generator.LanguageConfig;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.NamingAware;
import org.eclipse.xtext.generator.NewlineNormalizer;
import org.eclipse.xtext.generator.adapter.StringConcatOutputImpl;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xtext.generator.AbstractXtextGeneratorFragment;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.Issues;
import org.eclipse.xtext.xtext.generator.MweIssues;
import org.eclipse.xtext.xtext.generator.XtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

@Deprecated(forRemoval=true)
public class FragmentAdapter
extends AbstractXtextGeneratorFragment {
    @Inject
    private CodeConfig codeConfig;
    @Inject
    private IEncodingProvider encodingProvider;
    @Inject
    private XtextGeneratorNaming xtextGeneratorNaming;
    private IGeneratorFragment fragment;
    private Naming naming;
    private final List<PostProcessor> postProcessors = new ArrayList<PostProcessor>();

    public FragmentAdapter() {
    }

    public FragmentAdapter(IGeneratorFragment fragment) {
        this.setFragment(fragment);
    }

    public void addPostProcessor(PostProcessor postProcessor) {
        this.postProcessors.add(postProcessor);
    }

    public void checkConfiguration(Issues issues) {
        if (this.naming == null) {
            this.naming = this.createNaming();
        }
        if (this.fragment == null) {
            issues.addError("The property 'fragment' must be set.", (Object)this);
        } else {
            this.fragment.checkConfiguration(((MweIssues)issues).getDelegate());
        }
    }

    public void generate() {
        if (this.naming == null) {
            this.naming = this.createNaming();
        }
        XpandExecutionContext ctx = this.createExecutionContext();
        LanguageConfig config1 = this.createLanguageConfig();
        if (this.fragment instanceof IGeneratorFragmentExtension2) {
            ((IGeneratorFragmentExtension2)((Object)this.fragment)).generate(config1, ctx);
        } else {
            this.fragment.generate(config1.getGrammar(), ctx);
        }
        this.generateStandaloneSetup(config1, ctx);
        this.generateGuiceModuleRt(config1, ctx);
        this.generateGuiceModuleUi(config1, ctx);
        this.generatePluginXmlRt(config1, ctx);
        this.generateManifestRt(config1, ctx);
        this.generatePluginXmlUi(config1, ctx);
        this.generateManifestUi(config1, ctx);
        this.generateManifestIde(config1, ctx);
        this.generateManifestTests(config1, ctx);
    }

    private void generateStandaloneSetup(LanguageConfig config1, XpandExecutionContext ctx) {
        ctx.getOutput().openFile(null, "StringConcatOutputImpl.StringOutlet");
        try {
            IXtextGeneratorLanguage config2 = this.getLanguage();
            if (this.fragment instanceof IGeneratorFragmentExtension2) {
                ((IGeneratorFragmentExtension2)((Object)this.fragment)).addToStandaloneSetup(config1, ctx);
            } else {
                this.fragment.addToStandaloneSetup(config1.getGrammar(), ctx);
            }
            final StringConcatenation result = ((StringConcatOutputImpl)ctx.getOutput()).getStringOutlet();
            config2.getRuntimeGenSetup().getRegistrations().add(new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation builder) {
                    builder.append((Object)FragmentAdapter.this.decreaseIndentation(result.toString(), 2));
                }
            });
            config2.getRuntimeGenSetup().getImports().add(new TypeReference("org.eclipse.emf.ecore.EPackage"));
            config2.getRuntimeGenSetup().getImports().add(new TypeReference("org.eclipse.emf.ecore.resource.Resource"));
        }
        finally {
            ctx.getOutput().closeFile();
        }
    }

    private void generateGuiceModuleRt(LanguageConfig config1, XpandExecutionContext ctx) {
        String superClass;
        IXtextGeneratorLanguage config2 = this.getLanguage();
        Set<Binding> bindings = this.fragment.getGuiceBindingsRt(config1.getGrammar());
        if (bindings != null) {
            config2.getRuntimeGenModule().addAll(Iterables.transform(bindings, it -> this.translateBinding((Binding)it)));
        }
        if (this.fragment instanceof IGeneratorFragmentExtension4 && (superClass = ((IGeneratorFragmentExtension4)((Object)this.fragment)).getDefaultRuntimeModuleClassName(config1.getGrammar())) != null) {
            config2.getRuntimeGenModule().setSuperClass(new TypeReference(superClass));
        }
    }

    private void generateGuiceModuleUi(LanguageConfig config1, XpandExecutionContext ctx) {
        String superClass;
        IXtextGeneratorLanguage config2 = this.getLanguage();
        Set<Binding> bindings = this.fragment.getGuiceBindingsUi(config1.getGrammar());
        if (bindings != null) {
            config2.getEclipsePluginGenModule().addAll(Iterables.transform(bindings, it -> this.translateBinding((Binding)it)));
        }
        if (this.fragment instanceof IGeneratorFragmentExtension4 && (superClass = ((IGeneratorFragmentExtension4)((Object)this.fragment)).getDefaultUiModuleClassName(config1.getGrammar())) != null) {
            config2.getEclipsePluginGenModule().setSuperClass(new TypeReference(superClass));
        }
    }

    private GuiceModuleAccess.Binding translateBinding(Binding it) {
        GuiceModuleAccess.BindKey newKey;
        String[] statements = it.getValue().getStatements();
        if (statements == null || statements.length == 0) {
            String type = it.getKey().getType();
            TypeReference guessTypeRef = null;
            if (type != null) {
                guessTypeRef = TypeReference.guessTypeRef((String)type, (TypeReference[])new TypeReference[0]);
            }
            newKey = new GuiceModuleAccess.BindKey(null, guessTypeRef, it.getKey().isSingleton(), it.getKey().isEagerSingleton());
        } else {
            newKey = new GuiceModuleAccess.BindKey(this.getClassName(it.getKey().getType()), null, it.getKey().isSingleton(), it.getKey().isEagerSingleton());
        }
        String typeName = it.getValue().getTypeName();
        TypeReference guessTypeRef2 = null;
        if (typeName != null) {
            guessTypeRef2 = TypeReference.guessTypeRef((String)typeName, (TypeReference[])new TypeReference[0]);
        }
        List statementList = (List)Conversions.doWrapArray((Object)statements);
        GuiceModuleAccess.BindValue newValue = new GuiceModuleAccess.BindValue((Object)it.getValue().getExpression(), guessTypeRef2, it.getValue().isProvider(), Lists.transform((List)statementList, s -> {
            if (s.endsWith(";")) {
                return s;
            }
            return String.valueOf(s) + ";";
        }));
        return new GuiceModuleAccess.Binding(newKey, newValue, it.isFinal(), it.getContributedBy());
    }

    private String getClassName(String qualifiedName) {
        int classStart = qualifiedName.length();
        int i = qualifiedName.length() - 1;
        while (i >= 0) {
            if (this.matches(qualifiedName.charAt(i), '.')) {
                if (Character.isLowerCase(qualifiedName.charAt(i + 1))) {
                    return qualifiedName.substring(classStart);
                }
                classStart = i + 1;
            }
            --i;
        }
        return qualifiedName;
    }

    private void generatePluginXmlRt(LanguageConfig config1, XpandExecutionContext ctx) {
        if (this.getProjectConfig().getRuntime().getPluginXml() != null) {
            ctx.getOutput().openFile(null, "StringConcatOutputImpl.StringOutlet");
            try {
                if (this.fragment instanceof IGeneratorFragmentExtension2) {
                    ((IGeneratorFragmentExtension2)((Object)this.fragment)).addToPluginXmlRt(config1, ctx);
                } else {
                    this.fragment.addToPluginXmlRt(config1.getGrammar(), ctx);
                }
                StringConcatenation result = ((StringConcatOutputImpl)ctx.getOutput()).getStringOutlet();
                StringBuilder entry = this.decreaseIndentation(result.toString(), 1);
                if (!entry.toString().trim().isEmpty()) {
                    this.getProjectConfig().getRuntime().getPluginXml().getEntries().add(entry);
                }
            }
            finally {
                ctx.getOutput().closeFile();
            }
        }
    }

    private void generatePluginXmlUi(LanguageConfig config1, XpandExecutionContext ctx) {
        if (this.getProjectConfig().getEclipsePlugin().getPluginXml() != null) {
            ctx.getOutput().openFile(null, "StringConcatOutputImpl.StringOutlet");
            try {
                if (this.fragment instanceof IGeneratorFragmentExtension2) {
                    ((IGeneratorFragmentExtension2)((Object)this.fragment)).addToPluginXmlUi(config1, ctx);
                } else {
                    this.fragment.addToPluginXmlUi(config1.getGrammar(), ctx);
                }
                StringConcatenation result = ((StringConcatOutputImpl)ctx.getOutput()).getStringOutlet();
                StringBuilder entry = this.decreaseIndentation(result.toString(), 1);
                if (!entry.toString().trim().isEmpty()) {
                    this.getProjectConfig().getEclipsePlugin().getPluginXml().getEntries().add(entry);
                }
            }
            finally {
                ctx.getOutput().closeFile();
            }
        }
    }

    private void generateManifestRt(LanguageConfig config1, XpandExecutionContext ctx) {
        if (this.getProjectConfig().getRuntime().getManifest() != null) {
            Object[] imported;
            Object[] required;
            Object[] exported = this.fragment.getExportedPackagesRt(config1.getGrammar());
            if (exported != null) {
                CollectionExtensions.addAll((Collection)this.getProjectConfig().getRuntime().getManifest().getExportedPackages(), (Object[])exported);
            }
            if ((required = this.fragment.getRequiredBundlesRt(config1.getGrammar())) != null) {
                CollectionExtensions.addAll((Collection)this.getProjectConfig().getRuntime().getManifest().getRequiredBundles(), (Object[])required);
            }
            if ((imported = this.fragment.getImportedPackagesRt(config1.getGrammar())) != null) {
                CollectionExtensions.addAll((Collection)this.getProjectConfig().getRuntime().getManifest().getImportedPackages(), (Object[])imported);
            }
        }
    }

    private void generateManifestUi(LanguageConfig config1, XpandExecutionContext ctx) {
        if (this.getProjectConfig().getEclipsePlugin().getManifest() != null) {
            Object[] imported;
            Object[] required;
            Object[] exported = this.fragment.getExportedPackagesUi(config1.getGrammar());
            if (exported != null) {
                CollectionExtensions.addAll((Collection)this.getProjectConfig().getEclipsePlugin().getManifest().getExportedPackages(), (Object[])exported);
            }
            if ((required = this.fragment.getRequiredBundlesUi(config1.getGrammar())) != null) {
                CollectionExtensions.addAll((Collection)this.getProjectConfig().getEclipsePlugin().getManifest().getRequiredBundles(), (Object[])required);
            }
            if ((imported = this.fragment.getImportedPackagesUi(config1.getGrammar())) != null) {
                CollectionExtensions.addAll((Collection)this.getProjectConfig().getEclipsePlugin().getManifest().getImportedPackages(), (Object[])imported);
            }
        }
    }

    private void generateManifestIde(LanguageConfig config1, XpandExecutionContext ctx) {
        if (this.fragment instanceof IGeneratorFragmentExtension3 && this.getProjectConfig().getGenericIde().getManifest() != null) {
            Object[] imported;
            Object[] required;
            IGeneratorFragmentExtension3 fr = (IGeneratorFragmentExtension3)((Object)this.fragment);
            Object[] exported = fr.getExportedPackagesIde(config1.getGrammar());
            if (exported != null) {
                CollectionExtensions.addAll((Collection)this.getProjectConfig().getGenericIde().getManifest().getExportedPackages(), (Object[])exported);
            }
            if ((required = fr.getRequiredBundlesIde(config1.getGrammar())) != null) {
                CollectionExtensions.addAll((Collection)this.getProjectConfig().getGenericIde().getManifest().getRequiredBundles(), (Object[])required);
            }
            if ((imported = fr.getImportedPackagesIde(config1.getGrammar())) != null) {
                CollectionExtensions.addAll((Collection)this.getProjectConfig().getGenericIde().getManifest().getImportedPackages(), (Object[])imported);
            }
        }
    }

    private void generateManifestTests(LanguageConfig config1, XpandExecutionContext ctx) {
        if (this.fragment instanceof IGeneratorFragmentExtension && this.getProjectConfig().getRuntimeTest().getManifest() != null) {
            Object[] imported;
            Object[] required;
            IGeneratorFragmentExtension fr = (IGeneratorFragmentExtension)((Object)this.fragment);
            Object[] exported = fr.getExportedPackagesTests(config1.getGrammar());
            if (exported != null) {
                CollectionExtensions.addAll((Collection)this.getProjectConfig().getRuntimeTest().getManifest().getExportedPackages(), (Object[])exported);
            }
            if ((required = fr.getRequiredBundlesTests(config1.getGrammar())) != null) {
                CollectionExtensions.addAll((Collection)this.getProjectConfig().getRuntimeTest().getManifest().getRequiredBundles(), (Object[])required);
            }
            if ((imported = fr.getImportedPackagesTests(config1.getGrammar())) != null) {
                CollectionExtensions.addAll((Collection)this.getProjectConfig().getRuntimeTest().getManifest().getImportedPackages(), (Object[])imported);
            }
        }
    }

    protected Naming createNaming() {
        IXtextGeneratorLanguage config2 = this.getLanguage();
        Naming result = new Naming();
        IXtextGeneratorFileSystemAccess runtimeRoot = this.getProjectConfig().getRuntime().getRoot();
        String runtimeRootPath = null;
        if (runtimeRoot != null) {
            runtimeRootPath = runtimeRoot.getPath();
        }
        result.setProjectNameRt(this.getLastSegment(runtimeRootPath));
        IXtextGeneratorFileSystemAccess genericIdeRoot = this.getProjectConfig().getGenericIde().getRoot();
        String genericIdeRootPath = null;
        if (genericIdeRoot != null) {
            genericIdeRootPath = genericIdeRoot.getPath();
        }
        result.setProjectNameIde(this.getLastSegment(genericIdeRootPath));
        IXtextGeneratorFileSystemAccess eclipsePluginRoot = this.getProjectConfig().getEclipsePlugin().getRoot();
        String eclipsePluginRootPath = null;
        if (eclipsePluginRoot != null) {
            eclipsePluginRootPath = eclipsePluginRoot.getPath();
        }
        result.setProjectNameUi(this.getLastSegment(eclipsePluginRootPath));
        result.setIdeBasePackage(this.xtextGeneratorNaming.getGenericIdeBasePackage(config2.getGrammar()));
        result.setUiBasePackage(this.xtextGeneratorNaming.getEclipsePluginBasePackage(config2.getGrammar()));
        TypeReference eclipsePluginActivator = this.xtextGeneratorNaming.getEclipsePluginActivator();
        String activatorName = null;
        if (eclipsePluginActivator != null) {
            activatorName = eclipsePluginActivator.getName();
        }
        result.setActivatorName(activatorName);
        IXtextGeneratorFileSystemAccess runtimeTestRoot = this.getProjectConfig().getRuntimeTest().getRoot();
        String runtimeTestRootPath = null;
        if (runtimeTestRoot != null) {
            runtimeTestRootPath = runtimeTestRoot.getPath();
        }
        result.setPathTestProject(runtimeTestRootPath);
        result.setLineDelimiter(this.codeConfig.getLineDelimiter());
        result.setFileHeader(this.codeConfig.getFileHeader());
        result.setClassAnnotations(this.codeConfig.getClassAnnotationsAsString());
        result.setAnnotationImports(this.codeConfig.getAnnotationImportsAsString());
        result.setHasUI(result.getProjectNameUi() != null);
        result.setHasIde(result.getProjectNameIde() != null);
        result.setGrammarId(config2.getGrammar().getName());
        if (this.fragment instanceof NamingAware) {
            ((NamingAware)((Object)this.fragment)).registerNaming(result);
        }
        return result;
    }

    protected LanguageConfig createLanguageConfig() {
        XtextGeneratorLanguage config2 = (XtextGeneratorLanguage)this.getLanguage();
        LanguageConfig config = new LanguageConfig();
        config.setForcedResourceSet(config2.getResourceSet());
        config.setFileExtensions(Joiner.on((String)",").join((Iterable)config2.getFileExtensions()));
        config.setUri(config2.getGrammarUri());
        config.registerNaming(this.naming);
        return config;
    }

    protected XpandExecutionContext createExecutionContext() {
        String encoding = this.encodingProvider.getEncoding(null);
        StringConcatOutputImpl output = new StringConcatOutputImpl();
        if (this.getProjectConfig().getRuntime().getRoot() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "PLUGIN", false, this.getProjectConfig().getRuntime().getRoot().getPath()));
        }
        if (this.getProjectConfig().getRuntime().getSrc() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "SRC", false, this.getProjectConfig().getRuntime().getSrc().getPath()));
        }
        if (this.getProjectConfig().getRuntime().getSrcGen() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "SRC_GEN", true, this.getProjectConfig().getRuntime().getSrcGen().getPath()));
        }
        if (this.getProjectConfig().getRuntime().getRoot() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "MODEL", false, String.valueOf(this.getProjectConfig().getRuntime().getRoot().getPath()) + "/model"));
        }
        if (this.getProjectConfig().getEclipsePlugin().getRoot() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "PLUGIN_UI", false, this.getProjectConfig().getEclipsePlugin().getRoot().getPath()));
        } else if (this.getProjectConfig().getRuntime().getRoot() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "PLUGIN_UI", false, this.getProjectConfig().getRuntime().getRoot().getPath()));
        }
        if (this.getProjectConfig().getEclipsePlugin().getSrc() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "SRC_UI", false, this.getProjectConfig().getEclipsePlugin().getSrc().getPath()));
        } else if (this.getProjectConfig().getRuntime().getSrc() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "SRC_UI", false, this.getProjectConfig().getRuntime().getSrc().getPath()));
        }
        if (this.getProjectConfig().getEclipsePlugin().getSrcGen() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "SRC_GEN_UI", true, this.getProjectConfig().getEclipsePlugin().getSrcGen().getPath()));
        } else if (this.getProjectConfig().getRuntime().getSrcGen() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "SRC_GEN_UI", true, this.getProjectConfig().getRuntime().getSrcGen().getPath()));
        }
        if (this.getProjectConfig().getGenericIde().getRoot() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "PLUGIN_IDE", false, this.getProjectConfig().getGenericIde().getRoot().getPath()));
        } else if (this.getProjectConfig().getEclipsePlugin().getRoot() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "PLUGIN_IDE", false, this.getProjectConfig().getEclipsePlugin().getRoot().getPath()));
        } else if (this.getProjectConfig().getRuntime().getRoot() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "PLUGIN_IDE", false, this.getProjectConfig().getRuntime().getRoot().getPath()));
        }
        if (this.getProjectConfig().getGenericIde().getSrc() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "SRC_IDE", false, this.getProjectConfig().getGenericIde().getSrc().getPath()));
        } else if (this.getProjectConfig().getEclipsePlugin().getSrc() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "SRC_IDE", false, this.getProjectConfig().getEclipsePlugin().getSrc().getPath()));
        } else if (this.getProjectConfig().getRuntime().getSrc() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "SRC_IDE", false, this.getProjectConfig().getRuntime().getSrc().getPath()));
        }
        if (this.getProjectConfig().getGenericIde().getSrcGen() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "SRC_GEN_IDE", true, this.getProjectConfig().getGenericIde().getSrcGen().getPath()));
        } else if (this.getProjectConfig().getEclipsePlugin().getSrcGen() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "SRC_GEN_IDE", true, this.getProjectConfig().getEclipsePlugin().getSrcGen().getPath()));
        } else if (this.getProjectConfig().getRuntime().getSrcGen() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "SRC_GEN_IDE", true, this.getProjectConfig().getRuntime().getSrcGen().getPath()));
        }
        if (this.getProjectConfig().getRuntimeTest().getRoot() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "PLUGIN_TEST", false, this.getProjectConfig().getRuntimeTest().getRoot().getPath()));
        } else if (this.getProjectConfig().getRuntime().getRoot() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "PLUGIN_TEST", false, this.getProjectConfig().getRuntime().getRoot().getPath()));
        }
        if (this.getProjectConfig().getRuntimeTest().getSrc() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "SRC_TEST", false, this.getProjectConfig().getRuntimeTest().getSrc().getPath()));
        } else if (this.getProjectConfig().getRuntime().getSrc() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "SRC_TEST", false, this.getProjectConfig().getRuntime().getSrc().getPath()));
        }
        if (this.getProjectConfig().getRuntimeTest().getSrcGen() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "SRC_GEN_TEST", true, this.getProjectConfig().getRuntimeTest().getSrcGen().getPath()));
        } else if (this.getProjectConfig().getRuntime().getSrcGen() != null) {
            output.addOutlet(this.createOutlet(false, encoding, "SRC_GEN_TEST", true, this.getProjectConfig().getRuntime().getSrcGen().getPath()));
        }
        HashMap globalVars = Maps.newHashMap();
        globalVars.put("__Naming__", new Variable("__Naming__", (Object)this.naming));
        XpandExecutionContextImpl execCtx = new XpandExecutionContextImpl((Output)output, null, (Map)globalVars, null, null);
        execCtx.getResourceManager().setFileEncoding("ISO-8859-1");
        execCtx.registerMetaModel((MetaModel)new JavaBeansMetaModel());
        execCtx = (XpandExecutionContextImpl)execCtx.cloneWithVariable(new Variable("modelPluginID", (Object)this.naming.getProjectNameRt()));
        return execCtx;
    }

    protected Outlet createOutlet(boolean append, String encoding, String name, boolean overwrite, String path) {
        Outlet outlet = new Outlet(append, encoding, name, overwrite, path);
        outlet.addPostprocessor((PostProcessor)new NewlineNormalizer(this.codeConfig.getLineDelimiter()));
        for (PostProcessor pp : this.postProcessors) {
            outlet.addPostprocessor(pp);
        }
        return outlet;
    }

    protected String getPath(IFileSystemAccess2 fsa) {
        String path = fsa.getURI("").toFileString();
        if (path.endsWith(File.separator)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    private String getLastSegment(String path) {
        if (path != null) {
            return path.substring(path.lastIndexOf("/") + 1);
        }
        return null;
    }

    private StringBuilder decreaseIndentation(String text, int level) {
        StringBuilder result = new StringBuilder(text.length());
        boolean newLine = true;
        int skippedSpaces = 0;
        int skippedTabs = 0;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            boolean append = false;
            if (this.matches(c, '\n', '\r')) {
                newLine = true;
                append = true;
                skippedTabs = 0;
                skippedSpaces = 0;
            } else if (newLine) {
                if (this.matches(c, ' ')) {
                    if (++skippedSpaces >= 4) {
                        skippedSpaces = 0;
                        ++skippedTabs;
                    }
                } else if (this.matches(c, '\t')) {
                    skippedSpaces = 0;
                    ++skippedTabs;
                } else {
                    newLine = false;
                    append = true;
                }
                if (skippedTabs >= level) {
                    newLine = false;
                }
            } else {
                append = true;
            }
            if (append) {
                result.append(c);
            }
            ++i;
        }
        return result;
    }

    private boolean matches(char c, char ... m) {
        int i = 0;
        while (i < m.length) {
            if (c == m[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IGeneratorFragment getFragment() {
        return this.fragment;
    }

    public void setFragment(IGeneratorFragment fragment) {
        this.fragment = fragment;
    }

    public Naming getNaming() {
        return this.naming;
    }

    public void setNaming(Naming naming) {
        this.naming = naming;
    }
}

