/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.draw2d.layouts;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class CenteringLayout
extends AbstractLayout {
    protected static final int DEFAULT_WIDTH = 50;
    protected static final int DEFAULT_HEIGHT = 50;
    private double myScaleLevel;

    public CenteringLayout() {
    }

    public CenteringLayout(double scaleLevel) {
        this.setScale(scaleLevel);
    }

    public final double getScale() {
        return this.myScaleLevel;
    }

    public void setScale(double level) {
        if (level < 0.0 || level > 1.0) {
            throw new IllegalArgumentException();
        }
        this.myScaleLevel = level;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        List children = container.getChildren();
        if (children.isEmpty()) {
            return new Dimension(wHint < 0 ? 50 : wHint, hHint < 0 ? 50 : hHint);
        }
        IFigure child = (IFigure)children.get(0);
        Dimension size = child.getPreferredSize();
        if (size == null) {
            size = new Dimension(50, 50);
        } else {
            size = size.getCopy();
            if (this.myScaleLevel > 0.0) {
                size.width = (int)((double)size.width / this.myScaleLevel);
                size.height = (int)((double)size.height / this.myScaleLevel);
            }
        }
        if (wHint >= 0) {
            size.width = wHint;
        }
        if (hHint >= 0) {
            size.height = hHint;
        }
        return size;
    }

    public void layout(IFigure container) {
        Dimension size;
        Rectangle bounds = container.getClientArea();
        List children = container.getChildren();
        if (children.isEmpty()) {
            return;
        }
        IFigure child = (IFigure)children.get(0);
        if (this.myScaleLevel > 0.0) {
            size = bounds.getSize();
            size.width = (int)((double)size.width * this.myScaleLevel);
            size.height = (int)((double)size.height * this.myScaleLevel);
        } else {
            size = child.getPreferredSize(bounds.width, bounds.height);
            if (size == null) {
                size = new Dimension(50, 50);
            }
            if (size.width > bounds.width) {
                size.width = bounds.width;
            }
            if (size.height > bounds.height) {
                size.height = bounds.height;
            }
        }
        int woff = bounds.x + (bounds.width - size.width) / 2;
        int hoff = bounds.y + (bounds.height - size.height) / 2;
        child.setBounds(new Rectangle(woff, hoff, size.width, size.height));
    }
}

