/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.draw2d;

import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.uml2.diagram.common.draw2d.StereotypeLabel2;

public class NameAndStereotypeBlock
extends RectangleFigure {
    private StereotypeLabel2 myStereotypeLabel;
    private WrappingLabel myNameLabel;

    public NameAndStereotypeBlock() {
        this.setLineWidthFloat(0.0f);
        this.setOutline(false);
        this.setFill(false);
        this.setLayoutManager((LayoutManager)new TopBottomLayout());
        this.myStereotypeLabel = new StereotypeLabel2();
        this.myNameLabel = new WrappingLabel();
        this.myNameLabel.setAlignment(2);
        this.myNameLabel.setBackgroundColor(ColorConstants.yellow);
        this.add((IFigure)this.myStereotypeLabel, BorderLayout.TOP);
        this.add((IFigure)this.myNameLabel, BorderLayout.BOTTOM);
    }

    public StereotypeLabel2 getStereotypeLabel() {
        return this.myStereotypeLabel;
    }

    public WrappingLabel getNameLabel() {
        return this.myNameLabel;
    }

    public String toString() {
        boolean stereoVisible = this.getStereotypeLabel().isVisible();
        return "Stereo:" + this.getStereotypeLabel().getText() + ", [" + stereoVisible + "], Name: " + this.getNameLabel().getText();
    }

    public void setNameTextWrap(boolean nameTextWrap) {
        this.myNameLabel.setTextWrap(nameTextWrap);
    }

    private static class TopBottomLayout
    extends AbstractHintLayout {
        private IFigure top;
        private IFigure bottom;
        private int vGap = 5;
        private int hGap = 0;

        private TopBottomLayout() {
        }

        protected Dimension calculateMinimumSize(IFigure container, int wHint, int hHint) {
            Dimension childSize;
            int minWHint = 0;
            int minHHint = 0;
            if (wHint < 0) {
                minWHint = -1;
            }
            if (hHint < 0) {
                minHHint = -1;
            }
            Insets border = container.getInsets();
            wHint = Math.max(minWHint, wHint - border.getWidth());
            hHint = Math.max(minHHint, hHint - border.getHeight());
            Dimension minSize = new Dimension();
            int middleRowWidth = 0;
            int middleRowHeight = 0;
            int rows = 0;
            int columns = 0;
            if (this.top != null && this.top.isVisible()) {
                childSize = this.extractMinimumSize(this.top, wHint, hHint);
                hHint = Math.max(minHHint, hHint - (childSize.height + this.vGap));
                minSize.setSize(childSize);
                ++rows;
            }
            if (this.bottom != null && this.bottom.isVisible()) {
                childSize = this.extractMinimumSize(this.bottom, wHint, hHint);
                hHint = Math.max(minHHint, hHint - (childSize.height + this.vGap));
                minSize.width = Math.max(minSize.width, childSize.width);
                minSize.height += childSize.height;
                ++rows;
            }
            minSize.height += middleRowHeight + border.getHeight() + ((rows += columns > 0 ? 1 : 0) - 1) * this.vGap;
            minSize.width = Math.max(minSize.width, middleRowWidth) + border.getWidth() + (columns - 1) * this.hGap;
            return minSize;
        }

        private Dimension extractMinimumSize(IFigure figure, int wHint, int hHint) {
            if (figure instanceof StereotypeLabel2 && ((StereotypeLabel2)figure).isNeverHide()) {
                return figure.getPreferredSize(wHint, hHint);
            }
            return figure.getMinimumSize(wHint, hHint);
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            Dimension childSize;
            int minWHint = 0;
            int minHHint = 0;
            if (wHint < 0) {
                minWHint = -1;
            }
            if (hHint < 0) {
                minHHint = -1;
            }
            Insets border = container.getInsets();
            wHint = Math.max(minWHint, wHint - border.getWidth());
            hHint = Math.max(minHHint, hHint - border.getHeight());
            Dimension prefSize = new Dimension();
            int middleRowWidth = 0;
            int middleRowHeight = 0;
            int rows = 0;
            int columns = 0;
            if (this.top != null && this.top.isVisible()) {
                childSize = this.top.getPreferredSize(wHint, hHint);
                hHint = Math.max(minHHint, hHint - (childSize.height + this.vGap));
                prefSize.setSize(childSize);
                ++rows;
            }
            if (this.bottom != null && this.bottom.isVisible()) {
                childSize = this.bottom.getPreferredSize(wHint, hHint);
                hHint = Math.max(minHHint, hHint - (childSize.height + this.vGap));
                prefSize.width = Math.max(prefSize.width, childSize.width);
                prefSize.height += childSize.height;
                ++rows;
            }
            prefSize.height += middleRowHeight + border.getHeight() + ((rows += columns > 0 ? 1 : 0) - 1) * this.vGap;
            prefSize.width = Math.max(prefSize.width, middleRowWidth) + border.getWidth() + (columns - 1) * this.hGap;
            return prefSize;
        }

        public void layout(IFigure container) {
            Dimension childSize;
            Rectangle area = container.getClientArea();
            Rectangle rect = new Rectangle();
            if (this.top != null && this.top.isVisible()) {
                childSize = this.top.getPreferredSize(area.width, -1);
                rect.setLocation(area.x, area.y);
                rect.setSize(childSize);
                rect.width = area.width;
                this.top.setBounds(rect);
                area.y += rect.height + this.vGap;
                area.height -= rect.height + this.vGap;
            }
            if (this.bottom != null && this.bottom.isVisible()) {
                childSize = this.bottom.getPreferredSize(Math.max(area.width, 0), -1);
                rect.setSize(childSize);
                rect.width = area.width;
                rect.setLocation(area.x, area.y + area.height - rect.height);
                this.bottom.setBounds(rect);
                area.height -= rect.height + this.vGap;
            }
        }

        public void remove(IFigure child) {
            if (this.top == child) {
                this.top = null;
            } else if (this.bottom == child) {
                this.bottom = null;
            }
        }

        public void setConstraint(IFigure child, Object constraint) {
            this.remove(child);
            super.setConstraint(child, constraint);
            if (constraint == null) {
                return;
            }
            switch ((Integer)constraint) {
                case 8: {
                    this.top = child;
                    break;
                }
                case 32: {
                    this.bottom = child;
                    break;
                }
            }
        }

        public void setHorizontalSpacing(int gap) {
            this.hGap = gap;
        }

        public void setVerticalSpacing(int gap) {
            this.vGap = gap;
        }
    }
}

