/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.compartments;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableCompartmentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.handles.CompartmentCollapseHandle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.UMLCommonPlugin;
import org.eclipse.uml2.diagram.common.compartments.U2TCompartmentFigure;

public class U2TResizableCompartmentEditPolicy
extends ResizableCompartmentEditPolicy {
    protected List createCollapseHandles() {
        IGraphicalEditPart part = (IGraphicalEditPart)this.getHost();
        ArrayList<U2TCollapseHandle> collapseHandles = new ArrayList<U2TCollapseHandle>();
        collapseHandles.add(new U2TCollapseHandle(part));
        return collapseHandles;
    }

    protected static class U2TCollapseHandle
    extends CompartmentCollapseHandle
    implements IMapMode {
        private CollapsingLabel myCompartmentLabel;
        private IMapMode myOwnerMapMode;

        public U2TCollapseHandle(IGraphicalEditPart owner) {
            super(owner);
            if (this.getOwnerFigure() instanceof U2TCompartmentFigure) {
                U2TCompartmentFigure hostFigure = (U2TCompartmentFigure)this.getOwnerFigure();
                this.remove((IFigure)this.collapseFigure);
                this.collapseFigure.setVisible(false);
                this.myCompartmentLabel = this.createCompartmentLabel(hostFigure);
                this.add((IFigure)this.myCompartmentLabel);
                this.setLocator(new U2THandleLocator());
                this.myCompartmentLabel.setCollapsed(this.isStyleCollapsed());
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.myCompartmentLabel.setCollapsed(this.collapseFigure.isCollapsed());
        }

        public void notifyChanged(Notification notification) {
            if (NotationPackage.eINSTANCE.getDrawerStyle_Collapsed() == notification.getFeature()) {
                this.myCompartmentLabel.setCollapsed(notification.getNewBooleanValue());
            }
        }

        public IFigure findFigureAt(int x, int y, TreeSearch search) {
            IFigure found = super.findFigureAt(x, y, search);
            if (this.myCompartmentLabel != null && found != null) {
                return this;
            }
            return found;
        }

        public int DPtoLP(int deviceUnit) {
            return this.getOwnerMapMode().DPtoLP(deviceUnit);
        }

        public Translatable DPtoLP(Translatable t) {
            return this.getOwnerMapMode().DPtoLP(t);
        }

        public int LPtoDP(int logicalUnit) {
            return this.getOwnerMapMode().LPtoDP(logicalUnit);
        }

        public Translatable LPtoDP(Translatable t) {
            return this.getOwnerMapMode().LPtoDP(t);
        }

        private CollapsingLabel createCompartmentLabel(U2TCompartmentFigure hostFigure) {
            CollapsingLabel result = new CollapsingLabel(hostFigure.getTitleNotNull());
            result.setFont(hostFigure.getFont());
            return result;
        }

        private IGraphicalEditPart getOwnerImpl() {
            return (IGraphicalEditPart)this.getOwner();
        }

        private IMapMode getOwnerMapMode() {
            if (this.myOwnerMapMode == null) {
                this.myOwnerMapMode = MapModeUtil.getMapMode((IFigure)this.getOwnerFigure());
            }
            return this.myOwnerMapMode;
        }

        private boolean isStyleCollapsed() {
            View view = this.getOwnerImpl().getNotationView();
            if (view != null) {
                DrawerStyle style = (DrawerStyle)view.getStyle(NotationPackage.eINSTANCE.getDrawerStyle());
                return style != null && style.isCollapsed();
            }
            return false;
        }

        protected static class CollapsingLabel
        extends WrappingLabel {
            private Boolean myIsCollapsed;

            public CollapsingLabel(String text) {
                super(text);
                this.setOpaque(true);
                this.setTextPlacement(16);
                this.setIconAlignment(32);
                this.setTextAlignment(32);
                this.setAlignment(2);
            }

            public void setCollapsed(boolean isCollapsed) {
                if (this.myIsCollapsed != null && this.myIsCollapsed == isCollapsed) {
                    return;
                }
                this.myIsCollapsed = isCollapsed;
                this.setIcon(UMLCommonPlugin.getInstance().getImageRegistry().get(isCollapsed ? "icons/plus.gif" : "icons/minus.gif"));
                this.revalidate();
                this.repaint();
            }
        }

        protected class U2THandleLocator
        implements Locator {
            private static final int LABEL_LINE_GAP = 6;

            protected U2THandleLocator() {
            }

            public void relocate(IFigure target) {
                if (U2TCollapseHandle.this.getOwnerFigure() instanceof U2TCompartmentFigure) {
                    U2TCompartmentFigure figureImpl = (U2TCompartmentFigure)U2TCollapseHandle.this.getOwnerFigure();
                    Rectangle theBounds = figureImpl.getTextPaneBounds().getCopy();
                    U2TCollapseHandle.this.getOwnerFigure().translateToAbsolute((Translatable)theBounds);
                    target.translateToRelative((Translatable)theBounds);
                    Dimension actualTextBounds = U2TCollapseHandle.this.myCompartmentLabel.getPreferredSize(-1, -1);
                    theBounds.width = Math.min(theBounds.width, actualTextBounds.width + 12);
                    theBounds.translate(6, 0);
                    target.setBounds(theBounds);
                }
            }
        }
    }
}

