/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.rdf.resource.parser.element;

import java.net.URI;
import org.eclipse.eodm.rdf.resource.parser.element.RDFResourceElement;
import org.eclipse.eodm.rdf.resource.parser.exception.ParserException;

public class URIReference
implements RDFResourceElement {
    public static final String POUND = "#";
    private String namespace = null;
    private String localName = null;
    private String query = null;
    private URI uriRef = null;

    public URIReference(String uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new ParserException("URI must be not null.");
        }
        this.createURI(uri);
        this.namespace = this.namespace.intern();
        this.localName = this.localName.intern();
    }

    public URIReference(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new ParserException("URI must be not null.");
        }
        this.uriRef = uri;
        this.createURI();
        this.namespace = this.namespace.intern();
        this.localName = this.localName.intern();
    }

    public URIReference(String ns, String ln) throws ParserException {
        if (ns == null || ln == null) {
            throw new ParserException("URI namespace and local name must not be null.");
        }
        this.createURI(String.valueOf(ns) + ln);
        this.namespace = this.namespace.intern();
        this.localName = this.localName.intern();
    }

    private void createURI(String uri) throws IllegalArgumentException {
        uri = this.convertToValidURI(uri);
        this.uriRef = URI.create(uri);
        this.createURI();
    }

    private void createURI() throws IllegalArgumentException {
        this.query = this.uriRef.getQuery();
        if (this.uriRef.getFragment() != null) {
            this.namespace = String.valueOf(this.uriRef.getScheme()) + ":" + this.uriRef.getSchemeSpecificPart() + POUND;
            this.localName = this.uriRef.getFragment();
            this.namespace = this.convertToValidURI(this.namespace);
            this.localName = this.convertToValidURI(this.localName);
            return;
        }
        this.namespace = String.valueOf(this.uriRef.getScheme()) + ":" + this.uriRef.getSchemeSpecificPart();
        this.localName = "";
        if (this.uriRef.getPath() != null) {
            int lim = this.uriRef.getPath().lastIndexOf(47);
            if (lim >= 0) {
                this.localName = this.uriRef.getSchemeSpecificPart().substring(this.uriRef.getSchemeSpecificPart().lastIndexOf(47) + 1);
                this.namespace = this.namespace.substring(0, this.namespace.lastIndexOf(47) + 1);
            } else {
                this.localName = this.query == null ? "" : "?" + this.query;
                this.namespace = String.valueOf(this.uriRef.getScheme()) + ":" + this.uriRef.getSchemeSpecificPart().substring(0, this.uriRef.getSchemeSpecificPart().lastIndexOf(this.localName));
            }
        }
        this.namespace = this.convertToValidURI(this.namespace);
        this.localName = this.convertToValidURI(this.localName);
    }

    public boolean isAbsolute() {
        return this.uriRef.isAbsolute();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getFullURI() {
        return this.namespace.concat(this.localName);
    }

    public URIReference relative(String relPath) throws ParserException {
        relPath = this.convertToValidURI(relPath);
        if (!this.isAbsolute()) {
            throw new ParserException("The uri " + this.getFullURI() + " is not an absolute uri.");
        }
        URI relURI = null;
        relURI = URI.create(relPath);
        if (relURI.isAbsolute()) {
            return new URIReference(relURI);
        }
        if (relPath.startsWith(POUND)) {
            String uri = this.getNamespace();
            uri = uri.endsWith(POUND) ? String.valueOf(uri) + relPath.substring(1) : (uri.endsWith("/") ? String.valueOf(uri) + this.localName + relPath : String.valueOf(uri) + relPath);
            return new URIReference(uri);
        }
        if (relPath.startsWith("//")) {
            return new URIReference(String.valueOf(this.uriRef.getScheme()) + ":" + relPath);
        }
        if (relPath.startsWith("/")) {
            String prefix = this.uriRef.getSchemeSpecificPart().substring(0, this.uriRef.getSchemeSpecificPart().lastIndexOf(this.uriRef.getPath()));
            String absPath = String.valueOf(this.uriRef.getScheme()) + ":" + prefix;
            return new URIReference(String.valueOf(absPath) + relPath);
        }
        if (relPath.startsWith(".") || relPath.startsWith("./") || relPath.startsWith("..") || relPath.startsWith("../")) {
            String basePath = String.valueOf(this.uriRef.getScheme()) + ":" + this.uriRef.getSchemeSpecificPart().substring(0, this.uriRef.getSchemeSpecificPart().lastIndexOf(this.uriRef.getPath()));
            String absPath = this.getRelativePath(this.uriRef.getPath().startsWith("/") ? this.uriRef.getPath().substring(0, this.uriRef.getPath().lastIndexOf(47)) : "", relPath);
            return new URIReference(String.valueOf(basePath) + absPath);
        }
        String curPath = this.uriRef.toString();
        if (this.uriRef.getFragment() != null) {
            curPath = curPath.substring(0, curPath.length() - this.uriRef.getFragment().length() - 1);
        }
        if (relPath.length() == 0) {
            return new URIReference(curPath);
        }
        if (this.uriRef.getPath() == null || this.uriRef.getPath().length() == 0) {
            return new URIReference(String.valueOf(curPath) + "/" + relPath);
        }
        return new URIReference(String.valueOf(curPath.substring(0, curPath.lastIndexOf(47) + 1)) + relPath);
    }

    private String getRelativePath(String originalPath, String relativePath) {
        if (".".equals(relativePath)) {
            return originalPath;
        }
        if (relativePath.startsWith("./")) {
            String relPath = relativePath.substring(2);
            if (!relPath.startsWith("/")) {
                relPath = "/" + relPath;
            }
            return String.valueOf(originalPath) + relPath;
        }
        if ("..".equals(relativePath)) {
            int slashPos = originalPath.lastIndexOf(47);
            if (slashPos < 0) {
                return "/" + relativePath;
            }
            return originalPath.substring(0, slashPos);
        }
        String result = originalPath;
        String tmp = relativePath;
        while (tmp.startsWith("../")) {
            int frag = result.lastIndexOf(47);
            if (frag < 0) break;
            result = result.substring(0, frag);
            tmp = tmp.substring(3);
        }
        if (!tmp.startsWith("/")) {
            tmp = "/" + tmp;
        }
        return String.valueOf(result) + tmp;
    }

    private String convertToValidURI(String uri) {
        if (uri == null || uri.length() == 0) {
            return uri;
        }
        String result = uri.replaceAll("<", "%3C");
        result = result.replaceAll(">", "%3E");
        result = result.replaceAll(" ", "%20");
        return result;
    }

    public String toString() {
        return this.getFullURI();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof URIReference)) {
            return false;
        }
        URIReference uriReference = (URIReference)o;
        if (this.namespace != uriReference.namespace) {
            return false;
        }
        return this.localName == uriReference.localName;
    }

    public int hashCode() {
        int result = this.namespace.hashCode();
        result = 29 * result + this.localName.hashCode();
        return result;
    }
}

