/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class RequiredInterfaceDecoration
extends PolylineDecoration {
    private static final Point TEMP_POINT = new Point();
    private static final Rectangle TEMP_RECTANGLE = new Rectangle();
    private final int GAP = 3;
    private int myRadius;
    private int myAngle;

    public RequiredInterfaceDecoration() {
        this.setRadius(1);
        this.setScale(1.0, 1.0);
    }

    public void setRadius(int radius) {
        this.myRadius = radius;
        int[] nArray = new int[2];
        nArray[0] = radius - 3;
        this.setTemplate(new PointList(nArray));
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            super.getBounds();
            this.computeArcBounds(TEMP_RECTANGLE);
            TEMP_RECTANGLE.expand(1, 1);
            this.bounds.union(TEMP_RECTANGLE);
        }
        return this.bounds;
    }

    public void setRotation(double angle) {
        super.setRotation(angle);
        this.myAngle = (int)(angle * 180.0 / Math.PI);
    }

    protected void fillShape(Graphics g) {
    }

    protected void outlineShape(Graphics g) {
        this.computeArcBounds(TEMP_RECTANGLE);
        g.drawArc(TEMP_RECTANGLE, -this.myAngle + 90, 180);
    }

    private void computeArcBounds(Rectangle output) {
        if (this.getPoints().size() == 0) {
            output.setSize(0, 0);
            return;
        }
        this.getPoints().getPoint(TEMP_POINT, 0);
        output.setLocation(RequiredInterfaceDecoration.TEMP_POINT.x - this.myRadius, RequiredInterfaceDecoration.TEMP_POINT.y - this.myRadius);
        output.setSize(2 * this.myRadius, 2 * this.myRadius);
    }
}

