/**
 * <copyright>
 * </copyright>
 *
 * $Id: U2TGenItemProviderAdapterFactory.java,v 1.2 2009/03/10 15:48:55 tfesenko Exp $
 */
package org.eclipse.uml2.diagram.codegen.u2tgen.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.gmf.codegen.gmfgen.GMFGenPackage;
import org.eclipse.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.gmf.codegen.gmfgen.util.GMFGenSwitch;
import org.eclipse.uml2.diagram.codegen.edit.GMFExtEditPlugin;
import org.eclipse.uml2.diagram.codegen.u2tgen.U2TGenFactory;
import org.eclipse.uml2.diagram.codegen.u2tgen.util.U2TGenAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class U2TGenItemProviderAdapterFactory extends U2TGenAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public U2TGenItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.diagram.codegen.u2tgen.AuxSecondaryDiagramNodeAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AuxSecondaryDiagramNodeAttributeItemProvider auxSecondaryDiagramNodeAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.diagram.codegen.u2tgen.AuxSecondaryDiagramNodeAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAuxSecondaryDiagramNodeAttributeAdapter() {
		if (auxSecondaryDiagramNodeAttributeItemProvider == null) {
			auxSecondaryDiagramNodeAttributeItemProvider = new AuxSecondaryDiagramNodeAttributeItemProvider(this);
		}

		return auxSecondaryDiagramNodeAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.diagram.codegen.u2tgen.CustomLocatorAttributes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomLocatorAttributesItemProvider customLocatorAttributesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.diagram.codegen.u2tgen.CustomLocatorAttributes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomLocatorAttributesAdapter() {
		if (customLocatorAttributesItemProvider == null) {
			customLocatorAttributesItemProvider = new CustomLocatorAttributesItemProvider(this);
		}

		return customLocatorAttributesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.diagram.codegen.u2tgen.DetailsLevelAttributes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DetailsLevelAttributesItemProvider detailsLevelAttributesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.diagram.codegen.u2tgen.DetailsLevelAttributes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDetailsLevelAttributesAdapter() {
		if (detailsLevelAttributesItemProvider == null) {
			detailsLevelAttributesItemProvider = new DetailsLevelAttributesItemProvider(this);
		}

		return detailsLevelAttributesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.diagram.codegen.u2tgen.SubstitutableByAttributes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SubstitutableByAttributesItemProvider substitutableByAttributesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.diagram.codegen.u2tgen.SubstitutableByAttributes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSubstitutableByAttributesAdapter() {
		if (substitutableByAttributesItemProvider == null) {
			substitutableByAttributesItemProvider = new SubstitutableByAttributesItemProvider(this);
		}

		return substitutableByAttributesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.diagram.codegen.u2tgen.DynamicCanonicalCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DynamicCanonicalCompartmentItemProvider dynamicCanonicalCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.diagram.codegen.u2tgen.DynamicCanonicalCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDynamicCanonicalCompartmentAdapter() {
		if (dynamicCanonicalCompartmentItemProvider == null) {
			dynamicCanonicalCompartmentItemProvider = new DynamicCanonicalCompartmentItemProvider(this);
		}

		return dynamicCanonicalCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.diagram.codegen.u2tgen.InteractionDiagramAttributes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InteractionDiagramAttributesItemProvider interactionDiagramAttributesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.diagram.codegen.u2tgen.InteractionDiagramAttributes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInteractionDiagramAttributesAdapter() {
		if (interactionDiagramAttributesItemProvider == null) {
			interactionDiagramAttributesItemProvider = new InteractionDiagramAttributesItemProvider(this);
		}

		return interactionDiagramAttributesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.diagram.codegen.u2tgen.RotatedLabelAttributes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RotatedLabelAttributesItemProvider rotatedLabelAttributesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.diagram.codegen.u2tgen.RotatedLabelAttributes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRotatedLabelAttributesAdapter() {
		if (rotatedLabelAttributesItemProvider == null) {
			rotatedLabelAttributesItemProvider = new RotatedLabelAttributesItemProvider(this);
		}

		return rotatedLabelAttributesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.diagram.codegen.u2tgen.StereotypeSupportAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StereotypeSupportAttributeItemProvider stereotypeSupportAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.diagram.codegen.u2tgen.StereotypeSupportAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStereotypeSupportAttributeAdapter() {
		if (stereotypeSupportAttributeItemProvider == null) {
			stereotypeSupportAttributeItemProvider = new StereotypeSupportAttributeItemProvider(this);
		}

		return stereotypeSupportAttributeItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (auxSecondaryDiagramNodeAttributeItemProvider != null) auxSecondaryDiagramNodeAttributeItemProvider.dispose();
		if (customLocatorAttributesItemProvider != null) customLocatorAttributesItemProvider.dispose();
		if (detailsLevelAttributesItemProvider != null) detailsLevelAttributesItemProvider.dispose();
		if (substitutableByAttributesItemProvider != null) substitutableByAttributesItemProvider.dispose();
		if (dynamicCanonicalCompartmentItemProvider != null) dynamicCanonicalCompartmentItemProvider.dispose();
		if (interactionDiagramAttributesItemProvider != null) interactionDiagramAttributesItemProvider.dispose();
		if (rotatedLabelAttributesItemProvider != null) rotatedLabelAttributesItemProvider.dispose();
		if (stereotypeSupportAttributeItemProvider != null) stereotypeSupportAttributeItemProvider.dispose();
	}

	/**
	 * A child creation extender for the {@link GMFGenPackage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static class GMFGenChildCreationExtender implements IChildCreationExtender {
		/**
		 * The switch for creating child descriptors specific to each extended class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		protected static class CreationSwitch extends GMFGenSwitch<Object> {
			/**
			 * The child descriptors being populated.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected List<Object> newChildDescriptors;

			/**
			 * The domain in which to create the children.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected EditingDomain editingDomain;

			/**
			 * Creates the a switch for populating child descriptors in the given domain.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			CreationSwitch(List<Object> newChildDescriptors, EditingDomain editingDomain) {
				this.newChildDescriptors = newChildDescriptors;
				this.editingDomain = editingDomain;
			}
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseViewmap(Viewmap object) {
				newChildDescriptors.add
					(createChildParameter
						(GMFGenPackage.eINSTANCE.getViewmap_Attributes(),
						 U2TGenFactory.eINSTANCE.createAuxSecondaryDiagramNodeAttribute()));

				newChildDescriptors.add
					(createChildParameter
						(GMFGenPackage.eINSTANCE.getViewmap_Attributes(),
						 U2TGenFactory.eINSTANCE.createCustomLocatorAttributes()));

				newChildDescriptors.add
					(createChildParameter
						(GMFGenPackage.eINSTANCE.getViewmap_Attributes(),
						 U2TGenFactory.eINSTANCE.createDetailsLevelAttributes()));

				newChildDescriptors.add
					(createChildParameter
						(GMFGenPackage.eINSTANCE.getViewmap_Attributes(),
						 U2TGenFactory.eINSTANCE.createSubstitutableByAttributes()));

				newChildDescriptors.add
					(createChildParameter
						(GMFGenPackage.eINSTANCE.getViewmap_Attributes(),
						 U2TGenFactory.eINSTANCE.createDynamicCanonicalCompartment()));

				newChildDescriptors.add
					(createChildParameter
						(GMFGenPackage.eINSTANCE.getViewmap_Attributes(),
						 U2TGenFactory.eINSTANCE.createInteractionDiagramAttributes()));

				newChildDescriptors.add
					(createChildParameter
						(GMFGenPackage.eINSTANCE.getViewmap_Attributes(),
						 U2TGenFactory.eINSTANCE.createRotatedLabelAttributes()));

				newChildDescriptors.add
					(createChildParameter
						(GMFGenPackage.eINSTANCE.getViewmap_Attributes(),
						 U2TGenFactory.eINSTANCE.createStereotypeSupportAttribute()));

				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected CommandParameter createChildParameter(Object feature, Object child) {
				return new CommandParameter(null, feature, child);
			}

		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public Collection<Object> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
			ArrayList<Object> result = new ArrayList<Object>();
		   new CreationSwitch(result, editingDomain).doSwitch((EObject)object);
		   return result;
		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public ResourceLocator getResourceLocator() {
			return GMFExtEditPlugin.INSTANCE;
		}
	}

}
