/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.deploy.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.diagram.deploy.expressions.UMLAbstractExpression;
import org.eclipse.uml2.diagram.deploy.part.UMLDiagramEditorPlugin;

public class ElementInitializers {

    public static class Initializers {
        private Initializers() {
        }

        static IFeatureInitializer createNewElementFeatureInitializer(EStructuralFeature initFeature, ObjectInitializer[] newObjectInitializers) {
            final EStructuralFeature feature = initFeature;
            final ObjectInitializer[] initializers = newObjectInitializers;
            return new IFeatureInitializer(){

                public void init(EObject contextInstance) {
                    int i = 0;
                    while (i < initializers.length) {
                        EObject newInstance = initializers[i].element.getEPackage().getEFactoryInstance().create(initializers[i].element);
                        if (feature.isMany()) {
                            ((Collection)contextInstance.eGet(feature)).add(newInstance);
                        } else {
                            contextInstance.eSet(feature, (Object)newInstance);
                        }
                        initializers[i].init(newInstance);
                        ++i;
                    }
                }
            };
        }

        static IFeatureInitializer createExpressionFeatureInitializer(EStructuralFeature initFeature, UMLAbstractExpression valueExpression) {
            final EStructuralFeature feature = initFeature;
            final UMLAbstractExpression expression = valueExpression;
            return new IFeatureInitializer(){

                public void init(EObject contextInstance) {
                    expression.assignTo(feature, contextInstance);
                }
            };
        }

        static interface IFeatureInitializer {
            public void init(EObject var1);
        }

        public static interface IObjectInitializer {
            public void init(EObject var1);
        }

        static class Java {
            Java() {
            }
        }

        public static abstract class ObjectInitializer
        implements IObjectInitializer {
            final EClass element;
            private List featureInitializers = new ArrayList();

            ObjectInitializer(EClass element) {
                this.element = element;
                this.init();
            }

            protected abstract void init();

            protected final IFeatureInitializer add(IFeatureInitializer initializer) {
                this.featureInitializers.add(initializer);
                return initializer;
            }

            public void init(EObject instance) {
                for (IFeatureInitializer nextExpr : this.featureInitializers) {
                    try {
                        nextExpr.init(instance);
                    }
                    catch (RuntimeException e) {
                        UMLDiagramEditorPlugin.getInstance().logError("Feature initialization failed", e);
                    }
                }
            }
        }
    }
}

