/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.parser.stereotype;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.uml2.diagram.parser.assist.FixedSetCompletionProcessor;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppliedStereotypeParser
implements ISemanticParser {
    private static final MessageFormat APPLIED_PROFILE = new MessageFormat("\u00ab{0}\u00bb");

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        Object feature;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            EStructuralFeature featureImpl = (EStructuralFeature)feature;
            return featureImpl.getName().startsWith("base_");
        }
        return false;
    }

    public List<?> getSemanticElementsBeingParsed(EObject eObject) {
        Element element = (Element)eObject;
        LinkedList result = new LinkedList();
        result.addAll(element.getStereotypeApplications());
        return result;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable subject) {
        NamedElement element = this.doAdapt(subject);
        LinkedList remaining = new LinkedList();
        remaining.addAll(element.getApplicableStereotypes());
        remaining.removeAll((Collection<?>)element.getAppliedStereotypes());
        LinkedList<String> names = new LinkedList<String>();
        for (Stereotype next : remaining) {
            names.add(next.getName());
        }
        return new FixedSetCompletionProcessor(names);
    }

    public String getEditString(IAdaptable element, int flags) {
        NamedElement subject = this.doAdapt(element);
        EList stereos = subject.getAppliedStereotypes();
        if (stereos.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (Stereotype next : stereos) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(next.getName());
        }
        return result.toString();
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        return UnexecutableCommand.INSTANCE;
    }

    public String getPrintString(IAdaptable element, int flags) {
        String editString = this.getEditString(element, flags);
        return editString == null || editString.length() == 0 ? editString : APPLIED_PROFILE.format(new Object[]{editString});
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return false;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.UNEDITABLE_STATUS;
    }

    private NamedElement doAdapt(IAdaptable adaptable) {
        NamedElement element = (NamedElement)adaptable.getAdapter(EObject.class);
        return element;
    }
}

