/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.resource;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.BodyOwner;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class XMI2UMLHelperImpl
extends XMIHelperImpl {
    public XMI2UMLHelperImpl(XMLResource resource) {
        super(resource);
    }

    public String getHREF(EObject obj) {
        String href = super.getHREF(obj);
        if (href.startsWith("pathmap://UML_METAMODELS/UML.metamodel.uml")) {
            href = "http://www.omg.org/spec/UML/20131001/UML.xmi" + href.substring(href.indexOf(35));
        } else if (href.startsWith("pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml")) {
            href = "http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi" + href.substring(href.indexOf(35));
        } else if (href.startsWith("pathmap://UML_PROFILES/Standard.profile.uml")) {
            href = "http://www.omg.org/spec/UML/20131001/StandardProfile.xmi" + href.substring(href.indexOf(35));
        }
        return href;
    }

    public Object getValue(EObject eObject, EStructuralFeature eStructuralFeature) {
        EObject eContainer;
        BodyOwner bodyOwner = null;
        if (eStructuralFeature == UMLPackage.Literals.OPAQUE_BEHAVIOR__BODY) {
            for (EStructuralFeature.Setting inverseReference : UML2Util.getInverseReferences((EObject)eObject)) {
                if (inverseReference.getEStructuralFeature() != UMLPackage.Literals.BEHAVIORAL_FEATURE__METHOD || !(inverseReference.getEObject() instanceof Operation)) continue;
                bodyOwner = (BodyOwner)eObject;
                break;
            }
        } else if (eStructuralFeature == UMLPackage.Literals.OPAQUE_EXPRESSION__BODY && (eContainer = eObject.eContainer()) instanceof Constraint) {
            for (EStructuralFeature.Setting nonNavigableInverseReference : UML2Util.getNonNavigableInverseReferences((EObject)eContainer)) {
                if (nonNavigableInverseReference.getEStructuralFeature() != UMLPackage.Literals.OPERATION__BODY_CONDITION) continue;
                bodyOwner = (BodyOwner)eObject;
                break;
            }
        }
        if (bodyOwner != null) {
            EList<String> languages = bodyOwner.getLanguages();
            ArrayList<String> bodies = new ArrayList<String>((Collection<String>)bodyOwner.getBodies());
            int size = Math.min(languages.size(), bodies.size());
            int i = 0;
            while (i < size) {
                String body;
                if ("OCL".equals(languages.get(i)) && UML2Util.safeEquals((Object)(body = (String)bodies.get(i)), (Object)UMLUtil.getOCLBody(body))) {
                    bodies.set(i, "result = (" + body + ")");
                }
                ++i;
            }
            return bodies;
        }
        return super.getValue(eObject, eStructuralFeature);
    }
}

