/*
 * Decompiled with CFR 0.152.
 */
package org.omg.smm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BinaryFunctor implements Enumerator
{
    PLUS(0, "plus", "plus"),
    MINUS(1, "minus", "minus"),
    MULTIPLY(2, "multiply", "multiply"),
    DIVIDE(3, "divide", "divide"),
    CUSTOM(4, "custom", "custom");

    public static final int PLUS_VALUE = 0;
    public static final int MINUS_VALUE = 1;
    public static final int MULTIPLY_VALUE = 2;
    public static final int DIVIDE_VALUE = 3;
    public static final int CUSTOM_VALUE = 4;
    private static final BinaryFunctor[] VALUES_ARRAY;
    public static final List<BinaryFunctor> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BinaryFunctor[]{PLUS, MINUS, MULTIPLY, DIVIDE, CUSTOM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BinaryFunctor get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BinaryFunctor result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BinaryFunctor getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BinaryFunctor result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BinaryFunctor get(int value) {
        switch (value) {
            case 0: {
                return PLUS;
            }
            case 1: {
                return MINUS;
            }
            case 2: {
                return MULTIPLY;
            }
            case 3: {
                return DIVIDE;
            }
            case 4: {
                return CUSTOM;
            }
        }
        return null;
    }

    private BinaryFunctor(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

