/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml14.traceability.commands;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.requirements.sysml14.common.Utils;
import org.eclipse.papyrus.requirements.sysml14.traceability.commands.DerivationReqCreateCommand;
import org.eclipse.papyrus.sysml14.sysmlPackage;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class InitDerivedReqCommand
extends RecordingCommand {
    protected ArrayList<Element> selectedElements;
    TransactionalEditingDomain domain;

    public InitDerivedReqCommand(TransactionalEditingDomain domain, ArrayList<Element> selectedElements) {
        super(domain, "InitDerivedReqCommand");
        this.selectedElements = selectedElements;
        this.domain = domain;
    }

    protected void doExecute() {
        String concatenedString = "";
        Package owner = null;
        for (Element currentElement : this.selectedElements) {
            if (currentElement.getAppliedStereotype("SysML::Requirements::Requirement") == null) continue;
            Stereotype stereotype = currentElement.getAppliedStereotype("SysML::Requirements::Requirement");
            concatenedString = String.valueOf(concatenedString) + "\n" + currentElement.getValue(stereotype, "text");
            owner = currentElement.getNearestPackage();
        }
        TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getDefault().getActiveShell());
        dialog.setContentProvider((ITreeContentProvider)new UMLContentProvider((EObject)Utils.getToPackage(owner), (EStructuralFeature)UMLPackage.eINSTANCE.getPackage_NestedPackage()));
        dialog.setLabelProvider((ILabelProvider)new UMLLabelProvider());
        dialog.setMessage("Choose the owner of the new derived requirement");
        dialog.setTitle("Choose the owner of the new derived requirement");
        dialog.create();
        dialog.setDescription("Choose the owner of the new derived requirement");
        if (dialog.open() != 0) {
            return;
        }
        Object[] result = dialog.getResult();
        owner = (Package)result[0];
        Profile sysmlReqProfile = UMLUtil.getProfile((EPackage)sysmlPackage.eINSTANCE, (EObject)owner);
        ArrayList<Profile> requiredProfiles = new ArrayList<Profile>(Arrays.asList(sysmlReqProfile));
        ArrayList missingProfiles = Utils.getMissingRequiredProfileApplications((Package)owner, requiredProfiles);
        if (missingProfiles.size() > 0) {
            Utils.applyMissingProfiles((Package)owner, (ArrayList)missingProfiles);
        }
        String ID = Utils.getNewRequirementID((Element)owner);
        Class req = owner.createOwnedClass(ID, false);
        Stereotype reqStereotype = req.getApplicableStereotype("SysML::Requirements::Requirement");
        req.applyStereotype(reqStereotype);
        req.setValue(reqStereotype, "text", (Object)concatenedString);
        req.setValue(reqStereotype, "id", (Object)ID);
        for (Element currentElement : this.selectedElements) {
            if (currentElement.getAppliedStereotype("SysML::Requirements::Requirement") == null) continue;
            DerivationReqCreateCommand derivationReqCreateCommand = new DerivationReqCreateCommand(this.domain, (NamedElement)req, (NamedElement)currentElement);
            derivationReqCreateCommand.execute();
        }
    }
}

