/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.dev.tools.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.dev.tools.Activator;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.formatter.XMLFormatterFormatProcessor;

public class ExtractContentsXmlFileHandler
extends AbstractHandler {
    private static final String XML_EXTENSION = "xml";
    private static final String ODT_EXTENSION = "odt";
    private static final String OTT_EXTENSION = "ott";
    private static final String CONTENT_XML_FILE = "content.xml";
    private XMLFormatterFormatProcessor processor = new XMLFormatterFormatProcessor();

    private static final String getOSPathFromURI(URI uri) {
        String workspaceLocation = null;
        if (uri.isPlatformResource()) {
            workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))).getRawLocation().toOSString();
        }
        return workspaceLocation;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        for (URI uri : this.getSelectedOdtFileURI()) {
            String contentXMLLocation = ExtractContentsXmlFileHandler.getOSPathFromURI(uri.trimFileExtension().appendFileExtension(XML_EXTENSION));
            String odtFileLocation = ExtractContentsXmlFileHandler.getOSPathFromURI(uri);
            File odtFile = new File(odtFileLocation);
            try {
                ZipFile odtZipFile = new ZipFile(odtFile);
                Enumeration<? extends ZipEntry> entries = odtZipFile.entries();
                FileOutputStream outputStream = new FileOutputStream(contentXMLLocation);
                while (entries.hasMoreElements()) {
                    ZipEntry current = entries.nextElement();
                    if (!CONTENT_XML_FILE.equals(current.getName())) continue;
                    InputStream in = odtZipFile.getInputStream(current);
                    while (in.available() > 0) {
                        int read = in.read();
                        outputStream.write(read);
                    }
                    in.close();
                    break;
                }
                odtZipFile.close();
                outputStream.close();
                Activator.log.info(NLS.bind((String)"XML file extracted from {0}", (Object)uri.toString()));
            }
            catch (FileNotFoundException e) {
                Activator.log.error(NLS.bind((String)"XML file not found in {0}", (Object)uri.toString()), (Throwable)e);
            }
            catch (IOException e) {
                Activator.log.error(NLS.bind((String)"IOException extracting XML file from {0}", (Object)uri.toString()), (Throwable)e);
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(contentXMLLocation));
            if (file == null) continue;
            try {
                this.processor.formatFile(file);
                Activator.log.info(NLS.bind((String)"XML file {0} is now formatted", (Object)contentXMLLocation));
            }
            catch (IOException ex) {
                Activator.log.error(NLS.bind((String)"IOException formating the XML file from {0}", (Object)contentXMLLocation), (Throwable)ex);
            }
            catch (CoreException ex) {
                Activator.log.error(NLS.bind((String)"Exception during the formatting of {0}", (Object)contentXMLLocation), (Throwable)ex);
            }
        }
        try {
            Activator.log.info("Refresh workspace");
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.log.error("Exception during workspace refresh", (Throwable)e);
        }
        return null;
    }

    private final List<URI> getSelectedOdtFileURI() {
        Iterator iter = ExtractContentsXmlFileHandler.getCurrentStructuredSelection().iterator();
        ArrayList<URI> uris = new ArrayList<URI>();
        while (iter.hasNext()) {
            URI uri;
            Object current = iter.next();
            String pathName = null;
            if (current instanceof IAdaptable) {
                IFile f = (IFile)((IAdaptable)current).getAdapter(IFile.class);
                pathName = f.getFullPath().toPortableString();
            }
            if (!ODT_EXTENSION.equals((uri = URI.createPlatformResourceURI(pathName, (boolean)true)).fileExtension()) && !OTT_EXTENSION.equals(uri.fileExtension())) continue;
            uris.add(uri);
        }
        return uris;
    }

    public void setEnabled(Object evaluationContext) {
        super.setBaseEnabled(this.getSelectedOdtFileURI().size() > 0);
    }

    public static final ISelectionService getSelectionService() {
        IWorkbenchWindow ww;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (ww = wb.getActiveWorkbenchWindow()) != null) {
            return (ISelectionService)ww.getService(ISelectionService.class);
        }
        return null;
    }

    public static final ISelection getCurrentSelection() {
        ISelection currentSelection;
        ISelectionService selectionService = ExtractContentsXmlFileHandler.getSelectionService();
        if (selectionService != null && (currentSelection = selectionService.getSelection()) != null) {
            return currentSelection;
        }
        return StructuredSelection.EMPTY;
    }

    public static final IStructuredSelection getCurrentStructuredSelection() {
        ISelection selection = ExtractContentsXmlFileHandler.getCurrentSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }
}

