/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.internal.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.emf.documentstructure.BodyPart;
import org.eclipse.papyrus.model2doc.emf.documentstructure.ExtendedBasicList;
import org.eclipse.papyrus.model2doc.emf.documentstructure.ExtendedTextListItem;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Title;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IComposedListItemTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IComposedSubListItemTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.ILeafListItemTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.ILeafSubListItemTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IListItemTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IRootListItemTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.TreeListView;
import org.eclipse.papyrus.model2doc.emf.template2structure.Activator;
import org.eclipse.papyrus.model2doc.emf.template2structure.internal.mapping.AbstractEMFTemplateToStructureMapper;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.IMappingService;

public class TreeListViewMapper
extends AbstractEMFTemplateToStructureMapper<TreeListView> {
    public TreeListViewMapper() {
        super(TEMPLATE_EPACKAGE.getTreeListView(), BodyPart.class);
    }

    @Override
    protected <T> List<T> doMap(IMappingService mappingService, TreeListView treeListView, EObject semanticModelElement, Class<T> expectedReturnedClass) {
        if (!treeListView.generateBranch(semanticModelElement)) {
            return Collections.emptyList();
        }
        ArrayList<T> returnedElements = new ArrayList<T>();
        Iterator itemIterator = treeListView.getRootListItemTemplates().iterator();
        ArrayList<ExtendedTextListItem> createdListItems = new ArrayList<ExtendedTextListItem>();
        while (itemIterator.hasNext()) {
            IRootListItemTemplate current = (IRootListItemTemplate)itemIterator.next();
            createdListItems.addAll(this.createListItems((IListItemTemplate)current, semanticModelElement));
        }
        if (createdListItems.isEmpty()) {
            return null;
        }
        Title title = null;
        if (treeListView.isGenerate() && treeListView.isGenerateTitle()) {
            title = STRUCTURE_EFACTORY.createTitle();
            title.setTitle(treeListView.buildPartTemplateTitle(semanticModelElement));
            returnedElements.add(expectedReturnedClass.cast(title));
        }
        STRUCTURE_EFACTORY.createExtendedBasicList();
        ExtendedBasicList list = STRUCTURE_EFACTORY.createExtendedBasicList();
        list.getItems().addAll(createdListItems);
        if (title != null) {
            title.getSubBodyParts().add((Object)list);
        } else {
            returnedElements.add(expectedReturnedClass.cast(list));
        }
        return returnedElements;
    }

    private List<ExtendedTextListItem> createListItems(IListItemTemplate itemTemplate, EObject semanticModelElement) {
        if (itemTemplate instanceof ILeafListItemTemplate || itemTemplate instanceof ILeafSubListItemTemplate) {
            return this.createLeafListItems(itemTemplate, semanticModelElement);
        }
        if (itemTemplate instanceof IComposedListItemTemplate || itemTemplate instanceof IComposedSubListItemTemplate) {
            return this.createComposedListItems(itemTemplate, semanticModelElement);
        }
        Activator.log.warn(NLS.bind((String)"Element of type {0} is not managed.", (Object)itemTemplate.eClass().getName()));
        return Collections.emptyList();
    }

    private List<ExtendedTextListItem> createComposedListItems(IListItemTemplate itemTemplate, EObject semanticModelElement) {
        ArrayList<ExtendedTextListItem> createdItems = new ArrayList<ExtendedTextListItem>();
        EList semanticItems = itemTemplate.getItems(semanticModelElement);
        Iterator semanticItemsIterator = semanticItems.iterator();
        ExtendedTextListItem textItem = null;
        if (semanticItemsIterator.hasNext() && itemTemplate.isGenerateItem()) {
            textItem = STRUCTURE_EFACTORY.createExtendedTextListItem();
            createdItems.add(textItem);
            textItem.setText(itemTemplate.buildItemLabel((Object)semanticModelElement));
        }
        while (semanticItemsIterator.hasNext()) {
            Object subTemplates;
            Object currentSemanticItem = semanticItemsIterator.next();
            if (!(currentSemanticItem instanceof EObject)) continue;
            if (itemTemplate instanceof IComposedListItemTemplate) {
                subTemplates = ((IComposedListItemTemplate)itemTemplate).getSubListItemTemplates();
            } else if (itemTemplate instanceof IComposedSubListItemTemplate) {
                subTemplates = ((IComposedSubListItemTemplate)itemTemplate).getListItemTemplates();
            } else {
                Activator.log.warn(NLS.bind((String)"The item type {0} is not managed by {1}.", (Object)itemTemplate.eClass().getName(), (Object)this.getClass().getSimpleName()));
                subTemplates = Collections.emptyList();
            }
            for (IListItemTemplate subListItem : subTemplates) {
                List<ExtendedTextListItem> createdSubItem = this.createListItems(subListItem, (EObject)currentSemanticItem);
                if (textItem != null) {
                    textItem.getSubItems().addAll(createdSubItem);
                    continue;
                }
                createdItems.addAll(createdSubItem);
            }
        }
        return createdItems;
    }

    private List<ExtendedTextListItem> createLeafListItems(IListItemTemplate leafTemplate, EObject semanticModelElement) {
        ArrayList<ExtendedTextListItem> createdItems = new ArrayList<ExtendedTextListItem>();
        EList semanticItems = leafTemplate.getItems(semanticModelElement);
        Iterator semanticItemsIterator = semanticItems.iterator();
        ExtendedTextListItem featureNameItem = null;
        if (semanticItemsIterator.hasNext() && leafTemplate.isGenerateItem()) {
            featureNameItem = STRUCTURE_EFACTORY.createExtendedTextListItem();
            createdItems.add(featureNameItem);
            featureNameItem.setText(leafTemplate.buildItemLabel((Object)leafTemplate));
        }
        while (semanticItemsIterator.hasNext()) {
            Object currentSemanticItem = semanticItemsIterator.next();
            ExtendedTextListItem featureValueItem = STRUCTURE_EFACTORY.createExtendedTextListItem();
            String itemLabel = leafTemplate.buildItemLabel(currentSemanticItem);
            featureValueItem.setText(itemLabel);
            if (featureNameItem != null) {
                featureNameItem.getSubItems().add((Object)featureValueItem);
                continue;
            }
            createdItems.add(featureValueItem);
        }
        return createdItems;
    }
}

