/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.nattable.documentstructuretemplate.edit.internal.utils;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainMerger;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.nattable.common.helper.TableViewPrototype;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.utils.DocumentStructureTemplateUtils;

public class PapyrusTableUtils {
    public static final String UNDEFINED = "<Undefined>";

    private PapyrusTableUtils() {
    }

    public static final Collection<PapyrusTable> getPapyrusTables(EObject editedElement) {
        DocumentTemplate docTemplate = DocumentStructureTemplateUtils.getDocumentTemplate((EObject)editedElement);
        HashSet<PapyrusTable> tables = new HashSet<PapyrusTable>();
        if (docTemplate == null || docTemplate.getSemanticContext() == null) {
            ArchitectureDomainMerger m = ArchitectureDomainManager.getInstance().getMerger().clone();
            Collection domain = m.getDomains();
            for (MergedArchitectureDomain current : domain) {
                for (MergedArchitectureContext context : current.getContexts()) {
                    for (MergedArchitectureViewpoint v : context.getViewpoints()) {
                        for (RepresentationKind repKind : v.getRepresentationKinds()) {
                            if (!(repKind instanceof PapyrusTable)) continue;
                            tables.add((PapyrusTable)repKind);
                        }
                    }
                }
            }
            return tables;
        }
        EObject semanticContext = docTemplate.getSemanticContext();
        PolicyChecker policyChecker = PolicyChecker.getFor((Resource)semanticContext.eResource());
        policyChecker.getAllPrototypes().stream().filter(TableViewPrototype.class::isInstance).map(TableViewPrototype.class::cast).filter(proto -> proto.getRepresentationKind() instanceof PapyrusTable).forEach(proto -> {
            boolean bl = tables.add((PapyrusTable)proto.getRepresentationKind());
        });
        return tables;
    }
}

