/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.software.resource;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.iotml.software.resource.ResourceFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/uml2/2.0.0/UML originalName='Resource'"
 * @generated
 */
public interface ResourcePackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "resource";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/papyrus/iotml/0.7/IoTML/Software/Resource";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "Resource";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ResourcePackage eINSTANCE = org.eclipse.papyrus.iotml.software.resource.impl.ResourcePackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.software.resource.impl.NetworkResourceImpl <em>Network Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.software.resource.impl.NetworkResourceImpl
	 * @see org.eclipse.papyrus.iotml.software.resource.impl.ResourcePackageImpl#getNetworkResource()
	 * @generated
	 */
	int NETWORK_RESOURCE = 0;

	/**
	 * The feature id for the '<em><b>Base Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_RESOURCE__BASE_CLASS = 0;

	/**
	 * The number of structural features of the '<em>Network Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_RESOURCE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.software.resource.impl.OnDeviceResourceImpl <em>On Device Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.software.resource.impl.OnDeviceResourceImpl
	 * @see org.eclipse.papyrus.iotml.software.resource.impl.ResourcePackageImpl#getOnDeviceResource()
	 * @generated
	 */
	int ON_DEVICE_RESOURCE = 1;

	/**
	 * The feature id for the '<em><b>Base Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_DEVICE_RESOURCE__BASE_CLASS = 0;

	/**
	 * The feature id for the '<em><b>Device Broker</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_DEVICE_RESOURCE__DEVICE_BROKER = 1;

	/**
	 * The feature id for the '<em><b>Memory Broker</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_DEVICE_RESOURCE__MEMORY_BROKER = 2;

	/**
	 * The number of structural features of the '<em>On Device Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_DEVICE_RESOURCE_FEATURE_COUNT = 3;


	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.iotml.software.resource.NetworkResource <em>Network Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Network Resource</em>'.
	 * @see org.eclipse.papyrus.iotml.software.resource.NetworkResource
	 * @generated
	 */
	EClass getNetworkResource();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.software.resource.NetworkResource#getBase_Class <em>Base Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Base Class</em>'.
	 * @see org.eclipse.papyrus.iotml.software.resource.NetworkResource#getBase_Class()
	 * @see #getNetworkResource()
	 * @generated
	 */
	EReference getNetworkResource_Base_Class();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.iotml.software.resource.OnDeviceResource <em>On Device Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>On Device Resource</em>'.
	 * @see org.eclipse.papyrus.iotml.software.resource.OnDeviceResource
	 * @generated
	 */
	EClass getOnDeviceResource();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.software.resource.OnDeviceResource#getBase_Class <em>Base Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Base Class</em>'.
	 * @see org.eclipse.papyrus.iotml.software.resource.OnDeviceResource#getBase_Class()
	 * @see #getOnDeviceResource()
	 * @generated
	 */
	EReference getOnDeviceResource_Base_Class();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.software.resource.OnDeviceResource#getDeviceBroker <em>Device Broker</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Device Broker</em>'.
	 * @see org.eclipse.papyrus.iotml.software.resource.OnDeviceResource#getDeviceBroker()
	 * @see #getOnDeviceResource()
	 * @generated
	 */
	EReference getOnDeviceResource_DeviceBroker();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.software.resource.OnDeviceResource#getMemoryBroker <em>Memory Broker</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Memory Broker</em>'.
	 * @see org.eclipse.papyrus.iotml.software.resource.OnDeviceResource#getMemoryBroker()
	 * @see #getOnDeviceResource()
	 * @generated
	 */
	EReference getOnDeviceResource_MemoryBroker();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ResourceFactory getResourceFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.software.resource.impl.NetworkResourceImpl <em>Network Resource</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.software.resource.impl.NetworkResourceImpl
		 * @see org.eclipse.papyrus.iotml.software.resource.impl.ResourcePackageImpl#getNetworkResource()
		 * @generated
		 */
		EClass NETWORK_RESOURCE = eINSTANCE.getNetworkResource();

		/**
		 * The meta object literal for the '<em><b>Base Class</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NETWORK_RESOURCE__BASE_CLASS = eINSTANCE.getNetworkResource_Base_Class();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.software.resource.impl.OnDeviceResourceImpl <em>On Device Resource</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.software.resource.impl.OnDeviceResourceImpl
		 * @see org.eclipse.papyrus.iotml.software.resource.impl.ResourcePackageImpl#getOnDeviceResource()
		 * @generated
		 */
		EClass ON_DEVICE_RESOURCE = eINSTANCE.getOnDeviceResource();

		/**
		 * The meta object literal for the '<em><b>Base Class</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ON_DEVICE_RESOURCE__BASE_CLASS = eINSTANCE.getOnDeviceResource_Base_Class();

		/**
		 * The meta object literal for the '<em><b>Device Broker</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ON_DEVICE_RESOURCE__DEVICE_BROKER = eINSTANCE.getOnDeviceResource_DeviceBroker();

		/**
		 * The meta object literal for the '<em><b>Memory Broker</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ON_DEVICE_RESOURCE__MEMORY_BROKER = eINSTANCE.getOnDeviceResource_MemoryBroker();

	}

} //ResourcePackage
