/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.software.core.structure;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.iotml.software.core.structure.StructureFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/uml2/2.0.0/UML originalName='Structure'"
 * @generated
 */
public interface StructurePackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "structure";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/papyrus/iotml/0.7/IoTML/Software/Core/Structure";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "Structure";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	StructurePackage eINSTANCE = org.eclipse.papyrus.iotml.software.core.structure.impl.StructurePackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.software.core.structure.impl.MetaValueSpecificationImpl <em>Meta Value Specification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.software.core.structure.impl.MetaValueSpecificationImpl
	 * @see org.eclipse.papyrus.iotml.software.core.structure.impl.StructurePackageImpl#getMetaValueSpecification()
	 * @generated
	 */
	int META_VALUE_SPECIFICATION = 0;

	/**
	 * The feature id for the '<em><b>Base Value Specification</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_VALUE_SPECIFICATION__BASE_VALUE_SPECIFICATION = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_VALUE_SPECIFICATION__TYPE = 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_VALUE_SPECIFICATION__DESCRIPTION = 2;

	/**
	 * The number of structural features of the '<em>Meta Value Specification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_VALUE_SPECIFICATION_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.software.core.structure.impl.DetailedValueSpecificationImpl <em>Detailed Value Specification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.software.core.structure.impl.DetailedValueSpecificationImpl
	 * @see org.eclipse.papyrus.iotml.software.core.structure.impl.StructurePackageImpl#getDetailedValueSpecification()
	 * @generated
	 */
	int DETAILED_VALUE_SPECIFICATION = 1;

	/**
	 * The feature id for the '<em><b>Base Value Specification</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DETAILED_VALUE_SPECIFICATION__BASE_VALUE_SPECIFICATION = 0;

	/**
	 * The feature id for the '<em><b>Meta Specification</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DETAILED_VALUE_SPECIFICATION__META_SPECIFICATION = 1;

	/**
	 * The number of structural features of the '<em>Detailed Value Specification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DETAILED_VALUE_SPECIFICATION_FEATURE_COUNT = 2;


	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.iotml.software.core.structure.MetaValueSpecification <em>Meta Value Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Meta Value Specification</em>'.
	 * @see org.eclipse.papyrus.iotml.software.core.structure.MetaValueSpecification
	 * @generated
	 */
	EClass getMetaValueSpecification();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.software.core.structure.MetaValueSpecification#getBase_ValueSpecification <em>Base Value Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Base Value Specification</em>'.
	 * @see org.eclipse.papyrus.iotml.software.core.structure.MetaValueSpecification#getBase_ValueSpecification()
	 * @see #getMetaValueSpecification()
	 * @generated
	 */
	EReference getMetaValueSpecification_Base_ValueSpecification();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.software.core.structure.MetaValueSpecification#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see org.eclipse.papyrus.iotml.software.core.structure.MetaValueSpecification#getType()
	 * @see #getMetaValueSpecification()
	 * @generated
	 */
	EReference getMetaValueSpecification_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.iotml.software.core.structure.MetaValueSpecification#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.papyrus.iotml.software.core.structure.MetaValueSpecification#getDescription()
	 * @see #getMetaValueSpecification()
	 * @generated
	 */
	EAttribute getMetaValueSpecification_Description();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.iotml.software.core.structure.DetailedValueSpecification <em>Detailed Value Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Detailed Value Specification</em>'.
	 * @see org.eclipse.papyrus.iotml.software.core.structure.DetailedValueSpecification
	 * @generated
	 */
	EClass getDetailedValueSpecification();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.software.core.structure.DetailedValueSpecification#getBase_ValueSpecification <em>Base Value Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Base Value Specification</em>'.
	 * @see org.eclipse.papyrus.iotml.software.core.structure.DetailedValueSpecification#getBase_ValueSpecification()
	 * @see #getDetailedValueSpecification()
	 * @generated
	 */
	EReference getDetailedValueSpecification_Base_ValueSpecification();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.papyrus.iotml.software.core.structure.DetailedValueSpecification#getMetaSpecification <em>Meta Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Meta Specification</em>'.
	 * @see org.eclipse.papyrus.iotml.software.core.structure.DetailedValueSpecification#getMetaSpecification()
	 * @see #getDetailedValueSpecification()
	 * @generated
	 */
	EReference getDetailedValueSpecification_MetaSpecification();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	StructureFactory getStructureFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.software.core.structure.impl.MetaValueSpecificationImpl <em>Meta Value Specification</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.software.core.structure.impl.MetaValueSpecificationImpl
		 * @see org.eclipse.papyrus.iotml.software.core.structure.impl.StructurePackageImpl#getMetaValueSpecification()
		 * @generated
		 */
		EClass META_VALUE_SPECIFICATION = eINSTANCE.getMetaValueSpecification();

		/**
		 * The meta object literal for the '<em><b>Base Value Specification</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference META_VALUE_SPECIFICATION__BASE_VALUE_SPECIFICATION = eINSTANCE.getMetaValueSpecification_Base_ValueSpecification();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference META_VALUE_SPECIFICATION__TYPE = eINSTANCE.getMetaValueSpecification_Type();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute META_VALUE_SPECIFICATION__DESCRIPTION = eINSTANCE.getMetaValueSpecification_Description();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.software.core.structure.impl.DetailedValueSpecificationImpl <em>Detailed Value Specification</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.software.core.structure.impl.DetailedValueSpecificationImpl
		 * @see org.eclipse.papyrus.iotml.software.core.structure.impl.StructurePackageImpl#getDetailedValueSpecification()
		 * @generated
		 */
		EClass DETAILED_VALUE_SPECIFICATION = eINSTANCE.getDetailedValueSpecification();

		/**
		 * The meta object literal for the '<em><b>Base Value Specification</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DETAILED_VALUE_SPECIFICATION__BASE_VALUE_SPECIFICATION = eINSTANCE.getDetailedValueSpecification_Base_ValueSpecification();

		/**
		 * The meta object literal for the '<em><b>Meta Specification</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DETAILED_VALUE_SPECIFICATION__META_SPECIFICATION = eINSTANCE.getDetailedValueSpecification_MetaSpecification();

	}

} //StructurePackage
