/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.monitoring.sm.runnable;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.papyrus.designer.monitoring.sm.data.Message;
import org.eclipse.papyrus.designer.monitoring.sm.data.MessageQueue;
import org.eclipse.papyrus.designer.monitoring.sm.data.StateMachineModel;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;

public class MessageQueueDispatcher
implements Runnable {
    private boolean running = true;
    private final int sleepTime = 10;
    private MessageQueue socketDataMessageQueue;
    private Map<String, MessageQueue> animatorMessageQueues;
    private StateMachineModel stateMachineModel;

    public MessageQueueDispatcher(MessageQueue socketDataMessageQueue, Map<String, MessageQueue> animatorMessageQueueReaders, StateMachineModel stateMachineModel) {
        this.animatorMessageQueues = animatorMessageQueueReaders;
        this.socketDataMessageQueue = socketDataMessageQueue;
        this.stateMachineModel = stateMachineModel;
    }

    @Override
    public void run() {
        while (this.running) {
            Message message = null;
            if (this.socketDataMessageQueue != null) {
                message = this.socketDataMessageQueue.poll();
            }
            if (message != null) {
                MessageQueue animatorMessageQueue;
                State state;
                Transition transition;
                String header = message.getHeader();
                String data = message.getData();
                StateMachine containingStateMachine = null;
                String stateMachineQualifiedName = null;
                if (header.equals("TRANSITION") && this.stateMachineModel != null && (transition = this.stateMachineModel.getTransitionMap().get(data.trim())) != null) {
                    containingStateMachine = transition.containingStateMachine();
                }
                if (header.equals("STATE") && (state = this.stateMachineModel.getStateMap().get(data.trim())) != null) {
                    containingStateMachine = state.containingStateMachine();
                }
                if (containingStateMachine != null && (stateMachineQualifiedName = containingStateMachine.getQualifiedName()) != null && !stateMachineQualifiedName.isEmpty() && (animatorMessageQueue = this.animatorMessageQueues.get(stateMachineQualifiedName)) != null) {
                    animatorMessageQueue.getMessages().add(message);
                }
                if (header.equals("PAPYRUS_END_SM_MONITORING")) {
                    Iterator<Map.Entry<String, MessageQueue>> it = this.animatorMessageQueues.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<String, MessageQueue> pair = it.next();
                        if (pair.getValue() instanceof MessageQueue) {
                            MessageQueue animatorMessageQueue2 = pair.getValue();
                            animatorMessageQueue2.getMessages().add(message);
                        }
                        it.remove();
                    }
                    this.running = false;
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        this.running = false;
    }
}

