/**
 * Copyright (c) 2016 CEA LIST
 * 
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License 2.0 which
 * accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Ansgar Radermacher - Initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.idl.codegen;

import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Node;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class ComponentCDP {
  public static CharSequence generateCDP(final InstanceSpecification instance) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    _builder.newLine();
    _builder.append("<Deployment xmlns=\"http://www.omg.org/Deployment\"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("xsi:schemaLocation=\"http://www.omg.org/Deployment\">");
    _builder.newLine();
    _builder.newLine();
    _builder.append("<!-- Generated file with eC3M GenTools, CDP for instance specification ");
    String _name = instance.getName();
    _builder.append(_name);
    _builder.append(" -->");
    _builder.newLineIfNotEmpty();
    _builder.append("  ");
    _builder.newLine();
    _builder.append("<!--        ----------------- ");
    _builder.newLine();
    _builder.append("                ");
    _builder.append("artifacts");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("----------------- -->");
    _builder.newLine();
    _builder.newLine();
    {
      EList<InstanceSpecification> _containedInstances = ComponentCDP.getContainedInstances(instance);
      for(final InstanceSpecification subInstance : _containedInstances) {
        _builder.append("<!-- Artifact for ");
        String _name_1 = ComponentCDP.getClassifier(subInstance).getName();
        _builder.append(_name_1);
        _builder.append(" -->");
        _builder.newLineIfNotEmpty();
        _builder.append("<artifact id=\"artifact_");
        String _name_2 = ComponentCDP.getClassifier(subInstance).getName();
        _builder.append(_name_2);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<name>");
        String _name_3 = ComponentCDP.getClassifier(subInstance).getName();
        _builder.append(_name_3, "\t");
        _builder.append("</name>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<location>./libdummy.so</location>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<source></source>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<execParameter>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<name>home factory</name>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<value>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<type><kind>tk_string</kind></type>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<value><string>create_home_for_");
        String _name_4 = ComponentCDP.getClassifier(subInstance).getName();
        _builder.append(_name_4, "\t\t\t");
        _builder.append("</string></value>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("</value>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</execParameter>");
        _builder.newLine();
        _builder.append("</artifact>");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("<!--        -----------------");
    _builder.newLine();
    _builder.append("             ");
    _builder.append("implementations");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("----------------- -->");
    _builder.newLine();
    _builder.append("  ");
    _builder.newLine();
    {
      EList<InstanceSpecification> _containedInstances_1 = ComponentCDP.getContainedInstances(instance);
      for(final InstanceSpecification subInstance_1 : _containedInstances_1) {
        _builder.append("<implementation id=\"");
        String _name_5 = ComponentCDP.getClassifier(subInstance_1).getName();
        _builder.append(_name_5);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<name>");
        String _name_6 = ComponentCDP.getClassifier(subInstance_1).getName();
        _builder.append(_name_6, "\t");
        _builder.append("</name>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("// assumption on ccd location");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<source>");
        String _name_7 = ComponentCDP.getClassifier(subInstance_1).getName();
        _builder.append(_name_7, "\t");
        _builder.append(".ccd</source>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<artifact ref=\"artifact_");
        String _name_8 = ComponentCDP.getClassifier(subInstance_1).getName();
        _builder.append(_name_8, "\t");
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append("</implementation>");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("<!--        -----------------");
    _builder.newLine();
    _builder.append("                ");
    _builder.append("instances");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("----------------- -->");
    _builder.newLine();
    _builder.append("  ");
    _builder.newLine();
    {
      EList<InstanceSpecification> _containedInstances_2 = ComponentCDP.getContainedInstances(instance);
      for(final InstanceSpecification subInstance_2 : _containedInstances_2) {
        _builder.append("<!-- component ");
        String _name_9 = subInstance_2.getName();
        _builder.append(_name_9);
        _builder.append(" -->");
        _builder.newLineIfNotEmpty();
        _builder.append("<instance ID=\"");
        String _name_10 = subInstance_2.getName();
        _builder.append(_name_10);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<name>");
        String _name_11 = subInstance_2.getName();
        _builder.append(_name_11, "\t");
        _builder.append("</name>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<node>");
        String _name_12 = ComponentCDP.getNode(subInstance_2).getName();
        _builder.append(_name_12, "\t");
        _builder.append("</node>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<implementation ref=\"");
        String _name_13 = ComponentCDP.getClassifier(subInstance_2).getName();
        _builder.append(_name_13, "\t");
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append("</instance>");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("<!--        -----------------");
    _builder.newLine();
    _builder.append("               ");
    _builder.append("connections");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("----------------- -->");
    _builder.newLine();
    _builder.append("    ");
    _builder.newLine();
    _builder.append("// form of a loop, but in fact, there should be only one type         ");
    _builder.newLine();
    {
      EList<Classifier> _classifiers = instance.getClassifiers();
      for(final Classifier cl : _classifiers) {
        {
          EList<Connector> _ownedConnectors = ((org.eclipse.uml2.uml.Class) cl).getOwnedConnectors();
          for(final Connector connector : _ownedConnectors) {
            _builder.append("<!-- connection ");
            String _name_14 = connector.getName();
            _builder.append(_name_14);
            _builder.append(" -->");
            _builder.newLineIfNotEmpty();
            _builder.append("<connection id=\"");
            String _name_15 = connector.getName();
            _builder.append(_name_15);
            _builder.append("\">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("<name>");
            String _name_16 = connector.getName();
            _builder.append(_name_16, "\t");
            _builder.append("</name>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("<implementation ref=\"unknown\"/>");
            _builder.newLine();
            {
              EList<ConnectorEnd> _ends = connector.getEnds();
              for(final ConnectorEnd end : _ends) {
                _builder.append("<internalEndpoint>");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("<instance ref=\"");
                String _name_17 = ComponentCDP.getInstanceForPart(instance, end.getPartWithPort()).getName();
                _builder.append(_name_17, "\t");
                _builder.append("\">");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("<portName>");
                String _name_18 = end.getRole().getName();
                _builder.append(_name_18, "\t");
                _builder.append("</portName>");
                _builder.newLineIfNotEmpty();
                {
                  ConnectableElement _role = end.getRole();
                  int _size = ((Port) _role).getProvideds().size();
                  boolean _greaterThan = (_size > 0);
                  if (_greaterThan) {
                    _builder.append("\t");
                    _builder.append("<provider>true</provider>");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("<kind>Facet</kind>");
                    _builder.newLine();
                  } else {
                    ConnectableElement _role_1 = end.getRole();
                    int _size_1 = ((Port) _role_1).getRequireds().size();
                    boolean _greaterThan_1 = (_size_1 > 0);
                    if (_greaterThan_1) {
                      _builder.append("\t");
                      _builder.append("<provider>false</provider>");
                      _builder.newLine();
                      _builder.append("\t");
                      _builder.append("<kind>SimplexReceptacle</kind>");
                      _builder.newLine();
                    }
                  }
                }
                _builder.append("</internalEndpoint>");
                _builder.newLine();
              }
            }
            _builder.append("</connection>");
            _builder.newLine();
          }
        }
      }
    }
    return _builder;
  }
  
  /**
   * TODO: dummy definitions, real implementations are in component part of designer, need to have a strategy for utils class
   */
  public static Classifier getClassifier(final InstanceSpecification is) {
    return is.getClassifiers().get(0);
  }
  
  public static EList<InstanceSpecification> getContainedInstances(final InstanceSpecification is) {
    return null;
  }
  
  public static InstanceSpecification getInstanceForPart(final InstanceSpecification compositeIS, final Property part) {
    return null;
  }
  
  public static Node getNode(final InstanceSpecification is) {
    return null;
  }
}
