/*******************************************************************************
 * Copyright (c) 2011 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     CEA LIST - initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.designer.components.transformation.extensions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.designer.components.transformation.Activator;
import org.eclipse.papyrus.designer.components.transformation.Messages;

/**
 * Support for different OO transformation via the Eclipse extension
 * mechanism
 */
public class OOTrafo {

	public static final String IOO_TRANSFORMATION_ID = Activator.PLUGIN_ID + ".ooTransformation"; //$NON-NLS-1$

	/**
	 * Get an OOTransformation for a given ID (language)
	 * 
	 * @param iOOTrafoID
	 *            the ID of an OO Transformation
	 * @return The Java OO transformation
	 */
	public static IOOTrafo getOOTrafo(String iOOTrafoID) {
		IExtensionRegistry reg = Platform.getExtensionRegistry();
		IConfigurationElement[] configElements = reg.getConfigurationElementsFor(IOO_TRANSFORMATION_ID);
		for (IConfigurationElement configElement : configElements) {
			try {
				final String iOOTrafoIDext = configElement.getAttribute("ooTrafoID"); //$NON-NLS-1$
				if (iOOTrafoIDext == null) {
					throw new RuntimeException(String.format(Messages.InstanceConfigurator_InvalidPluginExtension,
							iOOTrafoID));
				}
				if (iOOTrafoIDext.endsWith("." + iOOTrafoID)) { //$NON-NLS-1$
					// TODO: cache returned instance (avoid creating a new
					// instance each time => more efficient, no need for static
					// attributes)
					final Object obj = configElement.createExecutableExtension("class"); //$NON-NLS-1$
					if (obj instanceof IOOTrafo) {
						return (IOOTrafo) obj;
					}
				}
			} catch (CoreException exception) {
				exception.printStackTrace();
			}
		}
		return null;
	}
}
