/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.extensions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationRTException;
import org.eclipse.papyrus.designer.transformation.extensions.Activator;
import org.eclipse.papyrus.designer.transformation.extensions.IM2MTrafo;
import org.eclipse.papyrus.designer.transformation.extensions.Messages;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.ApplyTransformation;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class M2MTrafoExt {
    public static final String TRANSFORMATION_ID = "transformationID";
    public static final String M2M_TRAFO = "org.eclipse.papyrus.designer.transformation.extensions.m2mTrafo";

    public static EList<M2MTrafo> getM2MTrafos(Element element) {
        ApplyTransformation applyTrafo = (ApplyTransformation)UMLUtil.getStereotypeApplication((Element)element, ApplyTransformation.class);
        if (applyTrafo != null) {
            return applyTrafo.getTrafo();
        }
        return null;
    }

    public static IM2MTrafo getM2MTrafo(M2MTrafo m2mTrafo) {
        if (m2mTrafo != null) {
            return M2MTrafoExt.getM2MTrafo(m2mTrafo.getBase_Class().getQualifiedName());
        }
        return null;
    }

    public static IM2MTrafo getM2MTrafoForLanguage(M2MTrafo m2mTrafo, String language) {
        return M2MTrafoExt.getM2MTrafo(String.format("%s::%s", m2mTrafo.getBase_Class().getQualifiedName(), language));
    }

    public static IM2MTrafo getM2MTrafo(String trafoID) {
        IConfigurationElement[] configElements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configElements = reg.getConfigurationElementsFor(M2M_TRAFO);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                Object obj;
                String transformationID = configElement.getAttribute(TRANSFORMATION_ID);
                if (transformationID != null && transformationID.equals(trafoID) && (obj = configElement.createExecutableExtension("class")) instanceof IM2MTrafo) {
                    return (IM2MTrafo)obj;
                }
            }
            catch (CoreException exception) {
                Activator.log.error((Throwable)exception);
            }
            ++n2;
        }
        throw new TransformationRTException(String.format(Messages.M2MTrafoExt_NoClassForTransformation, trafoID));
    }
}

