/**
 * Copyright (c) 2016 CEA LIST
 * 
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse License 2.0 which
 * accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Ansgar Radermacher - Initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.idl.codegen;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/**
 * Namespace related tools
 * As for C++, skip top-level namespace (test whether owner !== null)
 */
@SuppressWarnings("all")
public class Utils {
  public static CharSequence openNamespaceIDL(final NamedElement type) {
    StringConcatenation _builder = new StringConcatenation();
    {
      List<Namespace> _reverse = ListExtensions.<Namespace>reverse(((List<Namespace>)Conversions.doWrapArray(((Namespace[])Conversions.unwrapArray(type.allNamespaces(), Namespace.class)).clone())));
      for(final Namespace ns : _reverse) {
        {
          Element _owner = ns.getOwner();
          boolean _tripleNotEquals = (_owner != null);
          if (_tripleNotEquals) {
            _builder.append("module ");
            String _name = ns.getName();
            _builder.append(_name);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
  
  public static CharSequence closeNamespaceIDL(final NamedElement type) {
    StringConcatenation _builder = new StringConcatenation();
    {
      List<Namespace> _reverse = ListExtensions.<Namespace>reverse(((List<Namespace>)Conversions.doWrapArray(((Namespace[])Conversions.unwrapArray(type.allNamespaces(), Namespace.class)).clone())));
      for(final Namespace ns : _reverse) {
        {
          Element _owner = ns.getOwner();
          boolean _tripleNotEquals = (_owner != null);
          if (_tripleNotEquals) {
            _builder.append("}; // of module ");
            String _name = ns.getName();
            _builder.append(_name);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
  
  public static CharSequence dirName(final NamedElement type) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Namespace> _allNamespaces = type.allNamespaces();
      boolean _hasElements = false;
      for(final Namespace ns : _allNamespaces) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate("/", "");
        }
        String _name = ns.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
}
