/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.ocl.ecore.IterateExp;
import org.eclipse.ocl.ecore.LetExp;
import org.eclipse.ocl.ecore.LoopExp;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.examples.impactanalyzer.impl.OperationBodyToCallMapper;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AbstractTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.IdentityNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.IndirectingStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.PathCache;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableExpTracer
extends AbstractTracer<VariableExp> {
    public VariableExpTracer(VariableExp expression, Stack<String> tuplePartNames, OCLFactory oclFactory) {
        super(expression, tuplePartNames, oclFactory);
    }

    private Variable getVariableDeclaration() {
        return (Variable)((VariableExp)this.getExpression()).getReferredVariable();
    }

    private boolean isLetVariable() {
        Variable exp = this.getVariableDeclaration();
        return exp.eContainer() instanceof LetExp && ((LetExp)exp.eContainer()).getVariable() == exp;
    }

    private boolean isOperationParameter() {
        return this.getVariableDeclaration().getRepresentedParameter() != null;
    }

    private boolean isIterateResultVariable() {
        Variable exp = this.getVariableDeclaration();
        return exp.eContainer() instanceof IterateExp && ((IterateExp)exp.eContainer()).getResult() == exp;
    }

    private boolean isIteratorVariable() {
        Variable exp = this.getVariableDeclaration();
        return exp.eContainer() instanceof LoopExp && ((LoopExp)exp.eContainer()).getIterator().contains((Object)exp);
    }

    private boolean isSelf() {
        return this.getVariableDeclaration().getName().equals("self");
    }

    @Override
    public NavigationStep traceback(EClass context, PathCache pathCache, OperationBodyToCallMapper operationBodyToCallMapper) {
        NavigationStep result;
        if (this.isSelf()) {
            result = this.tracebackSelf(context, pathCache, operationBodyToCallMapper);
        } else if (this.isIteratorVariable()) {
            result = this.tracebackIteratorVariable(context, pathCache, operationBodyToCallMapper);
        } else if (this.isIterateResultVariable()) {
            result = this.tracebackIterateResultVariable(context, pathCache, operationBodyToCallMapper);
        } else if (this.isLetVariable()) {
            result = this.tracebackLetVariable(context, pathCache, operationBodyToCallMapper);
        } else if (this.isOperationParameter()) {
            result = this.tracebackOperationParameter(context, pathCache, operationBodyToCallMapper);
        } else {
            throw new RuntimeException("Unknown variable expression that is neither an iterator variable nor an iterate result variable nor an operation parameter nor a let variable nor self: " + ((VariableExp)this.getExpression()).getReferredVariable().getName());
        }
        this.applyScopesOnNavigationStep(result, operationBodyToCallMapper);
        return result;
    }

    private NavigationStep tracebackOperationParameter(EClass context, PathCache pathCache, OperationBodyToCallMapper operationBodyToCallMapper) {
        OCLExpression rootExpression = this.getRootExpression();
        EOperation op = (EOperation)operationBodyToCallMapper.getCallsOf(rootExpression).iterator().next().getReferredOperation();
        int pos = this.getParameterPosition(op);
        ArrayList<NavigationStep> stepsPerCall = new ArrayList<NavigationStep>();
        IndirectingStep indirectingStep = pathCache.createIndirectingStepFor((OCLExpression)this.getExpression(), this.getTupleLiteralPartNamesToLookFor());
        for (OperationCallExp call : operationBodyToCallMapper.getCallsOf(rootExpression)) {
            OCLExpression argumentExpression = (OCLExpression)call.getArgument().get(pos);
            NavigationStep stepForCall = (NavigationStep)pathCache.getOrCreateNavigationPath(argumentExpression, context, operationBodyToCallMapper, this.getTupleLiteralPartNamesToLookFor(), this.oclFactory);
            stepForCall.addLeavingScopes(VariableExpTracer.getAllVariablesInScope((OCLExpression)this.getExpression(), operationBodyToCallMapper));
            stepForCall.addEnteringScopes(VariableExpTracer.getAllVariablesInScope(argumentExpression, operationBodyToCallMapper));
            stepsPerCall.add(stepForCall);
        }
        indirectingStep.setActualStep(pathCache.navigationStepForBranch(this.getInnermostElementType((EClassifier)((VariableExp)this.getExpression()).getType()), context, (OCLExpression)this.getExpression(), this.getTupleLiteralPartNamesToLookFor(), false, stepsPerCall.toArray(new NavigationStep[0])));
        return indirectingStep;
    }

    private int getParameterPosition(EOperation op) {
        String variableName = this.getVariableDeclaration().getName();
        int pos = 0;
        EList pList = op.eContents();
        for (EObject p : pList) {
            if (!(p instanceof EParameter)) continue;
            if (variableName.equals(((EParameter)p).getName())) break;
            ++pos;
        }
        return pos;
    }

    private NavigationStep tracebackLetVariable(EClass context, PathCache pathCache, OperationBodyToCallMapper operationBodyToCallMapper) {
        NavigationStep result = (NavigationStep)pathCache.getOrCreateNavigationPath((OCLExpression)this.getVariableDeclaration().getInitExpression(), context, operationBodyToCallMapper, this.getTupleLiteralPartNamesToLookFor(), this.oclFactory);
        return result;
    }

    private NavigationStep tracebackIterateResultVariable(EClass context, PathCache pathCache, OperationBodyToCallMapper operationBodyToCallMapper) {
        NavigationStep stepForInitExpression = (NavigationStep)pathCache.getOrCreateNavigationPath((OCLExpression)this.getVariableDeclaration().getInitExpression(), context, operationBodyToCallMapper, this.getTupleLiteralPartNamesToLookFor(), this.oclFactory);
        IndirectingStep indirectingStep = pathCache.createIndirectingStepFor((OCLExpression)this.getExpression(), this.getTupleLiteralPartNamesToLookFor());
        NavigationStep stepForBodyExpression = (NavigationStep)pathCache.getOrCreateNavigationPath((OCLExpression)((IterateExp)this.getVariableDeclaration().eContainer()).getBody(), context, operationBodyToCallMapper, this.getTupleLiteralPartNamesToLookFor(), this.oclFactory);
        NavigationStep actualStepForIterateResultVariableExp = pathCache.navigationStepForBranch(this.getInnermostElementType((EClassifier)((VariableExp)this.getExpression()).getType()), context, (OCLExpression)this.getExpression(), this.getTupleLiteralPartNamesToLookFor(), false, stepForInitExpression, stepForBodyExpression);
        indirectingStep.setActualStep(actualStepForIterateResultVariableExp);
        return indirectingStep;
    }

    private NavigationStep tracebackIteratorVariable(EClass context, PathCache pathCache, OperationBodyToCallMapper operationBodyToCallMapper) {
        NavigationStep result;
        LoopExp loopExp = (LoopExp)this.getVariableDeclaration().eContainer();
        NavigationStep stepForSource = (NavigationStep)pathCache.getOrCreateNavigationPath((OCLExpression)loopExp.getSource(), context, operationBodyToCallMapper, this.getTupleLiteralPartNamesToLookFor(), this.oclFactory);
        if ("closure".equals(loopExp.getName())) {
            IndirectingStep indirectingStep = pathCache.createIndirectingStepFor((OCLExpression)this.getExpression(), this.getTupleLiteralPartNamesToLookFor());
            NavigationStep stepForBodyExpression = (NavigationStep)pathCache.getOrCreateNavigationPath((OCLExpression)loopExp.getBody(), context, operationBodyToCallMapper, this.getTupleLiteralPartNamesToLookFor(), this.oclFactory);
            NavigationStep actualStepForIterateResultVariableExp = pathCache.navigationStepForBranch(this.getInnermostElementType((EClassifier)((VariableExp)this.getExpression()).getType()), context, (OCLExpression)this.getExpression(), this.getTupleLiteralPartNamesToLookFor(), false, stepForSource, stepForBodyExpression);
            indirectingStep.setActualStep(actualStepForIterateResultVariableExp);
            result = indirectingStep;
        } else {
            result = stepForSource;
        }
        return result;
    }

    private NavigationStep tracebackSelf(EClass context, PathCache pathCache, OperationBodyToCallMapper operationBodyToCallMapper) {
        IndirectingStep result;
        EOperation op = this.getOperationOfWhichRootExpressionIsTheBody(operationBodyToCallMapper);
        if (op != null) {
            Set<OperationCallExp> calls = operationBodyToCallMapper.getCallsOf(this.getRootExpression());
            IndirectingStep indirectingStep = pathCache.createIndirectingStepFor((OCLExpression)this.getExpression(), this.getTupleLiteralPartNamesToLookFor());
            ArrayList<NavigationStep> stepsForCalls = new ArrayList<NavigationStep>();
            for (OperationCallExp call : calls) {
                OCLExpression callSource = (OCLExpression)call.getSource();
                NavigationStep stepForCall = (NavigationStep)pathCache.getOrCreateNavigationPath(callSource, context, operationBodyToCallMapper, this.getTupleLiteralPartNamesToLookFor(), this.oclFactory);
                stepForCall.addLeavingScopes(VariableExpTracer.getAllVariablesInScope((OCLExpression)this.getExpression(), operationBodyToCallMapper));
                stepForCall.addEnteringScopes(VariableExpTracer.getAllVariablesInScope(callSource, operationBodyToCallMapper));
                stepsForCalls.add(stepForCall);
            }
            indirectingStep.setActualStep(pathCache.navigationStepForBranch(this.getInnermostElementType((EClassifier)((VariableExp)this.getExpression()).getType()), context, (OCLExpression)this.getExpression(), this.getTupleLiteralPartNamesToLookFor(), false, stepsForCalls.toArray(new NavigationStep[0])));
            result = indirectingStep;
        } else {
            result = pathCache.createIndirectingStepFor((OCLExpression)this.getExpression(), this.getTupleLiteralPartNamesToLookFor());
            result.setActualStep(new IdentityNavigationStep((EClass)((VariableExp)this.getExpression()).getType(), (EClass)((VariableExp)this.getExpression()).getType(), (OCLExpression)this.getExpression()));
        }
        return result;
    }

    private EOperation getOperationOfWhichRootExpressionIsTheBody(OperationBodyToCallMapper operationBodyToCallMapper) {
        Set<OperationCallExp> filterSynthesizerCallCache = operationBodyToCallMapper.getCallsOf(this.getRootExpression());
        EOperation op = null;
        if (!filterSynthesizerCallCache.isEmpty()) {
            op = (EOperation)filterSynthesizerCallCache.iterator().next().getReferredOperation();
        }
        return op;
    }

    @Override
    protected Set<Variable> calculateLeavingScopes(OperationBodyToCallMapper operationBodyToCallMapper) {
        Set<Object> result = this.isLetVariable() ? this.getVariablesIntroducedBetweenHereAnd((OCLExpression)((LetExp)this.getVariableDeclaration().eContainer()).getIn(), operationBodyToCallMapper) : (this.isIteratorVariable() || this.isIterateResultVariable() ? this.getVariablesIntroducedBetweenHereAnd((OCLExpression)((LoopExp)this.getVariableDeclaration().eContainer()).getBody(), operationBodyToCallMapper) : (this.isOperationParameter() || this.isSelf() && this.getOperationOfWhichRootExpressionIsTheBody(operationBodyToCallMapper) != null ? VariableExpTracer.getAllVariablesInScope((OCLExpression)this.getExpression(), operationBodyToCallMapper) : Collections.emptySet()));
        return result;
    }
}

